/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.common.Time;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperThread;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderBean;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LearnerHandler;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.ProposalStats;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.StateSummary;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.ZxidUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Leader {
    private static final Logger LOG = LoggerFactory.getLogger(Leader.class);
    private static final boolean nodelay = System.getProperty("leader.nodelay", "true").equals("true");
    final LeaderZooKeeperServer zk;
    final QuorumPeer self;
    protected boolean quorumFormed = false;
    LearnerCnxAcceptor cnxAcceptor;
    private final HashSet<LearnerHandler> learners = new HashSet();
    private final HashSet<LearnerHandler> forwardingFollowers = new HashSet();
    private final ProposalStats proposalStats;
    private final HashSet<LearnerHandler> observingLearners = new HashSet();
    private final HashMap<Long, List<LearnerSyncRequest>> pendingSyncs = new HashMap();
    final AtomicLong followerCounter = new AtomicLong(-1L);
    ServerSocket ss;
    static final int DIFF = 13;
    static final int TRUNC = 14;
    static final int SNAP = 15;
    static final int OBSERVERINFO = 16;
    static final int NEWLEADER = 10;
    static final int FOLLOWERINFO = 11;
    static final int UPTODATE = 12;
    public static final int LEADERINFO = 17;
    public static final int ACKEPOCH = 18;
    static final int REQUEST = 1;
    public static final int PROPOSAL = 2;
    static final int ACK = 3;
    static final int COMMIT = 4;
    static final int PING = 5;
    static final int REVALIDATE = 6;
    static final int SYNC = 7;
    static final int INFORM = 8;
    ConcurrentMap<Long, Proposal> outstandingProposals = new ConcurrentHashMap<Long, Proposal>();
    ConcurrentLinkedQueue<Proposal> toBeApplied = new ConcurrentLinkedQueue();
    Proposal newLeaderProposal = new Proposal();
    StateSummary leaderStateSummary;
    long epoch = -1L;
    boolean waitingForNewEpoch = true;
    volatile boolean readyToStart = false;
    boolean isShutdown;
    long lastCommitted = -1L;
    long lastProposed;
    protected Set<Long> connectingFollowers = new HashSet<Long>();
    protected Set<Long> electingFollowers = new HashSet<Long>();
    protected boolean electionFinished = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getLearners() {
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.learners);
        }
    }

    public ProposalStats getProposalStats() {
        return this.proposalStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getForwardingFollowers() {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.forwardingFollowers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addForwardingFollower(LearnerHandler lh) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            this.forwardingFollowers.add(lh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getObservingLearners() {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.observingLearners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObserverLearnerHandler(LearnerHandler lh) {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            this.observingLearners.add(lh);
        }
    }

    public synchronized int getNumPendingSyncs() {
        return this.pendingSyncs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLearnerHandler(LearnerHandler learner) {
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            this.learners.add(learner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLearnerHandler(LearnerHandler peer) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            this.forwardingFollowers.remove(peer);
        }
        hashSet = this.learners;
        synchronized (hashSet) {
            this.learners.remove(peer);
        }
        hashSet = this.observingLearners;
        synchronized (hashSet) {
            this.observingLearners.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLearnerSynced(LearnerHandler peer) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            return this.forwardingFollowers.contains(peer);
        }
    }

    Leader(QuorumPeer self, LeaderZooKeeperServer zk) throws IOException {
        this.self = self;
        this.proposalStats = new ProposalStats();
        try {
            this.ss = self.getQuorumListenOnAllIPs() ? new ServerSocket(self.getQuorumAddress().getPort()) : new ServerSocket();
            this.ss.setReuseAddress(true);
            if (!self.getQuorumListenOnAllIPs()) {
                this.ss.bind(self.getQuorumAddress());
            }
        }
        catch (BindException e) {
            if (self.getQuorumListenOnAllIPs()) {
                LOG.error("Couldn't bind to port " + self.getQuorumAddress().getPort(), (Throwable)e);
            } else {
                LOG.error("Couldn't bind to " + self.getQuorumAddress(), (Throwable)e);
            }
            throw e;
        }
        this.zk = zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lead() throws IOException, InterruptedException {
        this.self.end_fle = Time.currentElapsedTime();
        long electionTimeTaken = this.self.end_fle - this.self.start_fle;
        this.self.setElectionTimeTaken(electionTimeTaken);
        LOG.info("LEADING - LEADER ELECTION TOOK - {}", (Object)electionTimeTaken);
        this.self.start_fle = 0L;
        this.self.end_fle = 0L;
        this.zk.registerJMX(new LeaderBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            this.self.tick.set(0);
            this.zk.loadData();
            this.leaderStateSummary = new StateSummary(this.self.getCurrentEpoch(), this.zk.getLastProcessedZxid());
            this.cnxAcceptor = new LearnerCnxAcceptor();
            this.cnxAcceptor.start();
            this.readyToStart = true;
            long epoch = this.getEpochToPropose(this.self.getId(), this.self.getAcceptedEpoch());
            this.zk.setZxid(ZxidUtils.makeZxid(epoch, 0L));
            Leader leader = this;
            synchronized (leader) {
                this.lastProposed = this.zk.getZxid();
            }
            this.newLeaderProposal.packet = new QuorumPacket(10, this.zk.getZxid(), null, null);
            if ((this.newLeaderProposal.packet.getZxid() & 0xFFFFFFFFL) != 0L) {
                LOG.info("NEWLEADER proposal has Zxid of " + Long.toHexString(this.newLeaderProposal.packet.getZxid()));
            }
            this.waitForEpochAck(this.self.getId(), this.leaderStateSummary);
            this.self.setCurrentEpoch(epoch);
            try {
                this.waitForNewLeaderAck(this.self.getId(), this.zk.getZxid());
            }
            catch (InterruptedException e) {
                this.shutdown("Waiting for a quorum of followers, only synced with sids: [ " + this.getSidSetString(this.newLeaderProposal.ackSet) + " ]");
                HashSet<Long> followerSet = new HashSet<Long>();
                for (LearnerHandler f : this.learners) {
                    followerSet.add(f.getSid());
                }
                if (this.self.getQuorumVerifier().containsQuorum(followerSet)) {
                    LOG.warn("Enough followers present. Perhaps the initTicks need to be increased.");
                }
                Thread.sleep(this.self.tickTime);
                this.self.tick.incrementAndGet();
                this.zk.unregisterJMX(this);
                return;
            }
            this.startZkServer();
            String initialZxid = System.getProperty("zookeeper.testingonly.initialZxid");
            if (initialZxid != null) {
                long zxid = Long.parseLong(initialZxid);
                this.zk.setZxid(this.zk.getZxid() & 0xFFFFFFFF00000000L | zxid);
            }
            if (!System.getProperty("zookeeper.leaderServes", "yes").equals("no")) {
                this.self.cnxnFactory.setZooKeeperServer(this.zk);
            }
            boolean tickSkip = true;
            while (true) {
                Thread.sleep(this.self.tickTime / 2);
                if (!tickSkip) {
                    this.self.tick.incrementAndGet();
                }
                HashSet<Long> syncedSet = new HashSet<Long>();
                syncedSet.add(this.self.getId());
                for (LearnerHandler f : this.getLearners()) {
                    if (f.synced() && f.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
                        syncedSet.add(f.getSid());
                    }
                    f.ping();
                }
                if (!this.isRunning()) {
                    this.shutdown("Unexpected internal error");
                    return;
                }
                if (!tickSkip && !this.self.getQuorumVerifier().containsQuorum(syncedSet)) {
                    this.shutdown("Not sufficient followers synced, only synced with sids: [ " + this.getSidSetString(syncedSet) + " ]");
                    return;
                }
                tickSkip = !tickSkip;
            }
        }
        finally {
            this.zk.unregisterJMX(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(String reason) {
        LOG.info("Shutting down");
        if (this.isShutdown) {
            return;
        }
        LOG.info("Shutdown called", (Throwable)new Exception("shutdown Leader! reason: " + reason));
        if (this.cnxAcceptor != null) {
            this.cnxAcceptor.halt();
        }
        this.self.cnxnFactory.setZooKeeperServer(null);
        try {
            this.ss.close();
        }
        catch (IOException e) {
            LOG.warn("Ignoring unexpected exception during close", (Throwable)e);
        }
        this.self.cnxnFactory.closeAll();
        if (this.zk != null) {
            this.zk.shutdown();
        }
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            Iterator<LearnerHandler> it = this.learners.iterator();
            while (it.hasNext()) {
                LearnerHandler f = it.next();
                it.remove();
                f.shutdown();
            }
        }
        this.isShutdown = true;
    }

    public synchronized void processAck(long sid, long zxid, SocketAddress followerAddr) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Ack zxid: 0x{}", (Object)Long.toHexString(zxid));
            for (Proposal p : this.outstandingProposals.values()) {
                long packetZxid = p.packet.getZxid();
                LOG.trace("outstanding proposal: 0x{}", (Object)Long.toHexString(packetZxid));
            }
            LOG.trace("outstanding proposals all");
        }
        if ((zxid & 0xFFFFFFFFL) == 0L) {
            return;
        }
        if (this.outstandingProposals.size() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("outstanding is 0");
            }
            return;
        }
        if (this.lastCommitted >= zxid) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("proposal has already been committed, pzxid: 0x{} zxid: 0x{}", (Object)Long.toHexString(this.lastCommitted), (Object)Long.toHexString(zxid));
            }
            return;
        }
        Proposal p = (Proposal)this.outstandingProposals.get(zxid);
        if (p == null) {
            LOG.warn("Trying to commit future proposal: zxid 0x{} from {}", (Object)Long.toHexString(zxid), (Object)followerAddr);
            return;
        }
        p.ackSet.add(sid);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Count for zxid: 0x{} is {}", (Object)Long.toHexString(zxid), (Object)p.ackSet.size());
        }
        if (this.self.getQuorumVerifier().containsQuorum(p.ackSet)) {
            if (zxid != this.lastCommitted + 1L) {
                LOG.warn("Commiting zxid 0x{} from {} not first!", (Object)Long.toHexString(zxid), (Object)followerAddr);
                LOG.warn("First is 0x{}", (Object)Long.toHexString(this.lastCommitted + 1L));
            }
            this.outstandingProposals.remove(zxid);
            if (p.request != null) {
                this.toBeApplied.add(p);
            }
            if (p.request == null) {
                LOG.warn("Going to commmit null request for proposal: {}", (Object)p);
            }
            this.commit(zxid);
            this.inform(p);
            this.zk.commitProcessor.commit(p.request);
            if (this.pendingSyncs.containsKey(zxid)) {
                for (LearnerSyncRequest r : this.pendingSyncs.remove(zxid)) {
                    this.sendSync(r);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(QuorumPacket qp) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            for (LearnerHandler f : this.forwardingFollowers) {
                f.queuePacket(qp);
            }
        }
    }

    void sendObserverPacket(QuorumPacket qp) {
        for (LearnerHandler f : this.getObservingLearners()) {
            f.queuePacket(qp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(long zxid) {
        Leader leader = this;
        synchronized (leader) {
            this.lastCommitted = zxid;
        }
        QuorumPacket qp = new QuorumPacket(4, zxid, null, null);
        this.sendPacket(qp);
    }

    public void inform(Proposal proposal) {
        QuorumPacket qp = new QuorumPacket(8, proposal.request.zxid, proposal.packet.getData(), null);
        this.sendObserverPacket(qp);
    }

    public long getEpoch() {
        return ZxidUtils.getEpochFromZxid(this.lastProposed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proposal propose(Request request) throws XidRolloverException {
        if ((request.zxid & 0xFFFFFFFFL) == 0xFFFFFFFFL) {
            String msg = "zxid lower 32 bits have rolled over, forcing re-election, and therefore new epoch start";
            this.shutdown(msg);
            throw new XidRolloverException(msg);
        }
        byte[] data = SerializeUtils.serializeRequest(request);
        this.proposalStats.setLastProposalSize(data.length);
        QuorumPacket pp = new QuorumPacket(2, request.zxid, data, null);
        Proposal p = new Proposal();
        p.packet = pp;
        p.request = request;
        Leader leader = this;
        synchronized (leader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proposing:: " + request);
            }
            this.lastProposed = p.packet.getZxid();
            this.outstandingProposals.put(this.lastProposed, p);
            this.sendPacket(pp);
        }
        return p;
    }

    public synchronized void processSync(LearnerSyncRequest r) {
        if (this.outstandingProposals.isEmpty()) {
            this.sendSync(r);
        } else {
            List<LearnerSyncRequest> l = this.pendingSyncs.get(this.lastProposed);
            if (l == null) {
                l = new ArrayList<LearnerSyncRequest>();
            }
            l.add(r);
            this.pendingSyncs.put(this.lastProposed, l);
        }
    }

    public void sendSync(LearnerSyncRequest r) {
        QuorumPacket qp = new QuorumPacket(7, 0L, null, null);
        r.fh.queuePacket(qp);
    }

    public synchronized long startForwarding(LearnerHandler handler, long lastSeenZxid) {
        if (this.lastProposed > lastSeenZxid) {
            for (Proposal p : this.toBeApplied) {
                if (p.packet.getZxid() <= lastSeenZxid) continue;
                handler.queuePacket(p.packet);
                QuorumPacket qp = new QuorumPacket(4, p.packet.getZxid(), null, null);
                handler.queuePacket(qp);
            }
            if (handler.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
                ArrayList zxids = new ArrayList(this.outstandingProposals.keySet());
                Collections.sort(zxids);
                for (Long zxid : zxids) {
                    if (zxid <= lastSeenZxid) continue;
                    handler.queuePacket(((Proposal)this.outstandingProposals.get((Object)zxid)).packet);
                }
            }
        }
        if (handler.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
            this.addForwardingFollower(handler);
        } else {
            this.addObserverLearnerHandler(handler);
        }
        return this.lastProposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEpochToPropose(long sid, long lastAcceptedEpoch) throws InterruptedException, IOException {
        Set<Long> set = this.connectingFollowers;
        synchronized (set) {
            if (!this.waitingForNewEpoch) {
                return this.epoch;
            }
            if (lastAcceptedEpoch >= this.epoch) {
                this.epoch = lastAcceptedEpoch + 1L;
            }
            if (this.isParticipant(sid)) {
                this.connectingFollowers.add(sid);
            }
            QuorumVerifier verifier = this.self.getQuorumVerifier();
            if (this.connectingFollowers.contains(this.self.getId()) && verifier.containsQuorum(this.connectingFollowers)) {
                this.waitingForNewEpoch = false;
                this.self.setAcceptedEpoch(this.epoch);
                this.connectingFollowers.notifyAll();
            } else {
                long start;
                long cur = start = Time.currentElapsedTime();
                long end = start + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (this.waitingForNewEpoch && cur < end) {
                    this.connectingFollowers.wait(end - cur);
                    cur = Time.currentElapsedTime();
                }
                if (this.waitingForNewEpoch) {
                    throw new InterruptedException("Timeout while waiting for epoch from quorum");
                }
            }
            return this.epoch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEpochAck(long id, StateSummary ss) throws IOException, InterruptedException {
        Set<Long> set = this.electingFollowers;
        synchronized (set) {
            if (this.electionFinished) {
                return;
            }
            if (ss.getCurrentEpoch() != -1L) {
                if (ss.isMoreRecentThan(this.leaderStateSummary)) {
                    throw new IOException("Follower is ahead of the leader, leader summary: " + this.leaderStateSummary.getCurrentEpoch() + " (current epoch), " + this.leaderStateSummary.getLastZxid() + " (last zxid)");
                }
                if (this.isParticipant(id)) {
                    this.electingFollowers.add(id);
                }
            }
            QuorumVerifier verifier = this.self.getQuorumVerifier();
            if (this.electingFollowers.contains(this.self.getId()) && verifier.containsQuorum(this.electingFollowers)) {
                this.electionFinished = true;
                this.electingFollowers.notifyAll();
            } else {
                long start;
                long cur = start = Time.currentElapsedTime();
                long end = start + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (!this.electionFinished && cur < end) {
                    this.electingFollowers.wait(end - cur);
                    cur = Time.currentElapsedTime();
                }
                if (!this.electionFinished) {
                    throw new InterruptedException("Timeout while waiting for epoch to be acked by quorum");
                }
            }
        }
    }

    private String getSidSetString(Set<Long> sidSet) {
        StringBuilder sids = new StringBuilder();
        Iterator<Long> iter = sidSet.iterator();
        while (iter.hasNext()) {
            sids.append(iter.next());
            if (!iter.hasNext()) break;
            sids.append(",");
        }
        return sids.toString();
    }

    private synchronized void startZkServer() {
        this.lastCommitted = this.zk.getZxid();
        LOG.info("Have quorum of supporters, sids: [ " + this.getSidSetString(this.newLeaderProposal.ackSet) + " ]; starting up and setting last processed zxid: 0x{}", (Object)Long.toHexString(this.zk.getZxid()));
        this.zk.startup();
        this.self.updateElectionVote(this.getEpoch());
        this.zk.getZKDatabase().setlastProcessedZxid(this.zk.getZxid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNewLeaderAck(long sid, long zxid) throws InterruptedException {
        HashSet<Long> hashSet = this.newLeaderProposal.ackSet;
        synchronized (hashSet) {
            if (this.quorumFormed) {
                return;
            }
            long currentZxid = this.newLeaderProposal.packet.getZxid();
            if (zxid != currentZxid) {
                LOG.error("NEWLEADER ACK from sid: " + sid + " is from a different epoch - current 0x" + Long.toHexString(currentZxid) + " receieved 0x" + Long.toHexString(zxid));
                return;
            }
            if (this.isParticipant(sid)) {
                this.newLeaderProposal.ackSet.add(sid);
            }
            if (this.self.getQuorumVerifier().containsQuorum(this.newLeaderProposal.ackSet)) {
                this.quorumFormed = true;
                this.newLeaderProposal.ackSet.notifyAll();
            } else {
                long start;
                long cur = start = Time.currentElapsedTime();
                long end = start + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (!this.quorumFormed && cur < end) {
                    this.newLeaderProposal.ackSet.wait(end - cur);
                    cur = Time.currentElapsedTime();
                }
                if (!this.quorumFormed) {
                    throw new InterruptedException("Timeout while waiting for NEWLEADER to be acked by quorum");
                }
            }
        }
    }

    public static String getPacketType(int packetType) {
        switch (packetType) {
            case 13: {
                return "DIFF";
            }
            case 14: {
                return "TRUNC";
            }
            case 15: {
                return "SNAP";
            }
            case 16: {
                return "OBSERVERINFO";
            }
            case 10: {
                return "NEWLEADER";
            }
            case 11: {
                return "FOLLOWERINFO";
            }
            case 12: {
                return "UPTODATE";
            }
            case 17: {
                return "LEADERINFO";
            }
            case 18: {
                return "ACKEPOCH";
            }
            case 1: {
                return "REQUEST";
            }
            case 2: {
                return "PROPOSAL";
            }
            case 3: {
                return "ACK";
            }
            case 4: {
                return "COMMIT";
            }
            case 5: {
                return "PING";
            }
            case 6: {
                return "REVALIDATE";
            }
            case 7: {
                return "SYNC";
            }
            case 8: {
                return "INFORM";
            }
        }
        return "UNKNOWN";
    }

    private boolean isRunning() {
        return this.self.isRunning() && this.zk.isRunning();
    }

    private boolean isParticipant(long sid) {
        return this.self.getVotingView().containsKey(sid);
    }

    static {
        LOG.info("TCP NoDelay set to: " + nodelay);
    }

    public static class XidRolloverException
    extends Exception {
        public XidRolloverException(String message) {
            super(message);
        }
    }

    static class ToBeAppliedRequestProcessor
    implements RequestProcessor {
        private RequestProcessor next;
        private ConcurrentLinkedQueue<Proposal> toBeApplied;

        ToBeAppliedRequestProcessor(RequestProcessor next, ConcurrentLinkedQueue<Proposal> toBeApplied) {
            if (!(next instanceof FinalRequestProcessor)) {
                throw new RuntimeException(ToBeAppliedRequestProcessor.class.getName() + " must be connected to " + FinalRequestProcessor.class.getName() + " not " + next.getClass().getName());
            }
            this.toBeApplied = toBeApplied;
            this.next = next;
        }

        @Override
        public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
            this.next.processRequest(request);
            Proposal p = this.toBeApplied.peek();
            if (p != null && p.request != null && p.request.zxid == request.zxid) {
                this.toBeApplied.remove();
            }
        }

        @Override
        public void shutdown() {
            LOG.info("Shutting down");
            this.next.shutdown();
        }
    }

    class LearnerCnxAcceptor
    extends ZooKeeperThread {
        private volatile boolean stop;

        public LearnerCnxAcceptor() {
            super("LearnerCnxAcceptor-" + Leader.this.ss.getLocalSocketAddress());
            this.stop = false;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    try {
                        Socket s = Leader.this.ss.accept();
                        s.setSoTimeout(Leader.this.self.tickTime * Leader.this.self.initLimit);
                        s.setTcpNoDelay(nodelay);
                        BufferedInputStream is = new BufferedInputStream(s.getInputStream());
                        LearnerHandler fh = new LearnerHandler(s, is, Leader.this);
                        fh.start();
                    }
                    catch (SocketException e) {
                        if (this.stop) {
                            LOG.info("exception while shutting down acceptor: " + e);
                            this.stop = true;
                            continue;
                        }
                        throw e;
                    }
                    catch (SaslException e) {
                        LOG.error("Exception while connecting to quorum learner", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Exception while accepting follower", (Throwable)e);
            }
        }

        public void halt() {
            this.stop = true;
        }
    }

    public static class Proposal {
        public QuorumPacket packet;
        public HashSet<Long> ackSet = new HashSet();
        public Request request;

        public String toString() {
            return this.packet.getType() + ", " + this.packet.getZxid() + ", " + this.request;
        }
    }
}

