/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.JMXEnv;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumBase;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHammerTest
extends ZKTestCase
implements AsyncCallback.StringCallback,
AsyncCallback.VoidCallback,
AsyncCallback.DataCallback {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncHammerTest.class);
    private QuorumBase qb = new QuorumBase();
    private volatile boolean bang;

    public void setUp(boolean withObservers) throws Exception {
        this.qb.setUp(withObservers);
    }

    protected void restart() throws Exception {
        LOG.info("RESTARTING " + this.getTestName());
        this.qb.tearDown();
        JMXEnv.setUp();
        this.qb.startServers();
    }

    public void tearDown() throws Exception {
        LOG.info("Test clients shutting down");
        this.qb.tearDown();
    }

    @Test
    public void testHammer() throws Exception {
        int i;
        this.setUp(false);
        this.bang = true;
        LOG.info("Starting hammers");
        HammerThread[] hammers = new HammerThread[100];
        for (i = 0; i < hammers.length; ++i) {
            hammers[i] = new HammerThread("HammerThread-" + i);
            hammers[i].start();
        }
        LOG.info("Started hammers");
        Thread.sleep(5000L);
        this.bang = false;
        LOG.info("Stopping hammers");
        for (i = 0; i < hammers.length; ++i) {
            hammers[i].interrupt();
            ClientBase.verifyThreadTerminated(hammers[i], 60000L);
            Assert.assertFalse((boolean)hammers[i].failed);
        }
        LOG.info("Hammers stopped, verifying consistency");
        this.qb.verifyRootOfAllServersMatch(this.qb.hostPort);
        this.restart();
        LOG.info("Verifying hammers 2");
        this.qb.verifyRootOfAllServersMatch(this.qb.hostPort);
        this.tearDown();
    }

    @Test
    public void testObserversHammer() throws Exception {
        int i;
        this.setUp(true);
        this.bang = true;
        Thread[] hammers = new Thread[100];
        for (i = 0; i < hammers.length; ++i) {
            hammers[i] = new HammerThread("HammerThread-" + i);
            hammers[i].start();
        }
        Thread.sleep(5000L);
        this.bang = false;
        for (i = 0; i < hammers.length; ++i) {
            hammers[i].interrupt();
            ClientBase.verifyThreadTerminated(hammers[i], 60000L);
        }
        this.qb.verifyRootOfAllServersMatch(this.qb.hostPort);
        this.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(int rc, String path, Object ctx, String name) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(int rc, String path, Object ctx) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    class HammerThread
    extends Thread
    implements AsyncCallback.StringCallback,
    AsyncCallback.VoidCallback {
        private static final int MAX_OUTSTANDING = 30;
        private TestableZooKeeper zk;
        private int outstanding;
        private volatile boolean failed;

        public HammerThread(String name) {
            super(name);
            this.failed = false;
        }

        @Override
        public void run() {
            try {
                ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
                this.zk = new TestableZooKeeper(((AsyncHammerTest)AsyncHammerTest.this).qb.hostPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
                watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
                while (AsyncHammerTest.this.bang) {
                    this.incOutstanding();
                    this.zk.create("/test-", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, (AsyncCallback.StringCallback)this, null);
                }
            }
            catch (InterruptedException e) {
                if (AsyncHammerTest.this.bang) {
                    LOG.error("sanity check Assert.failed!!!");
                    return;
                }
            }
            catch (Exception e) {
                LOG.error("Client create operation Assert.failed", (Throwable)e);
                return;
            }
            finally {
                if (this.zk != null) {
                    try {
                        this.zk.close();
                        if (!this.zk.testableWaitForShutdown(ClientBase.CONNECTION_TIMEOUT)) {
                            this.failed = true;
                            LOG.error("Client did not shutdown");
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info("Interrupted", (Throwable)e);
                    }
                }
            }
        }

        private synchronized void incOutstanding() throws InterruptedException {
            ++this.outstanding;
            while (this.outstanding > 30) {
                this.wait();
            }
        }

        private synchronized void decOutstanding() {
            --this.outstanding;
            Assert.assertTrue((String)"outstanding >= 0", (this.outstanding >= 0 ? 1 : 0) != 0);
            this.notifyAll();
        }

        public void process(WatchedEvent event) {
        }

        @Override
        public void processResult(int rc, String path, Object ctx, String name) {
            block4: {
                if (rc != KeeperException.Code.OK.intValue()) {
                    if (AsyncHammerTest.this.bang) {
                        this.failed = true;
                        LOG.error("Create Assert.failed for 0x" + Long.toHexString(this.zk.getSessionId()) + "with rc:" + rc + " path:" + path);
                    }
                    this.decOutstanding();
                    return;
                }
                try {
                    this.decOutstanding();
                    this.zk.delete(name, -1, (AsyncCallback.VoidCallback)this, null);
                }
                catch (Exception e) {
                    if (!AsyncHammerTest.this.bang) break block4;
                    this.failed = true;
                    LOG.error("Client delete Assert.failed", (Throwable)e);
                }
            }
        }

        @Override
        public void processResult(int rc, String path, Object ctx) {
            if (rc != KeeperException.Code.OK.intValue() && AsyncHammerTest.this.bang) {
                this.failed = true;
                LOG.error("Delete Assert.failed for 0x" + Long.toHexString(this.zk.getSessionId()) + "with rc:" + rc + " path:" + path);
            }
        }
    }
}

