/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.CacheDirective;

public class CacheDirectiveLock
extends Lock {
    private final Long id;
    private final TransactionLockTypes.LockType lockType;
    private final String poolName;
    private final int maxNumResults;
    private final String path;
    private List<CacheDirective> directives = null;

    public CacheDirectiveLock(long id) {
        this.lockType = TransactionLockTypes.LockType.WRITE;
        this.id = id;
        this.poolName = null;
        this.maxNumResults = -1;
        this.path = null;
    }

    public CacheDirectiveLock(String poolName) {
        this.lockType = TransactionLockTypes.LockType.WRITE;
        this.id = null;
        this.poolName = poolName;
        this.maxNumResults = -1;
        this.path = null;
    }

    public CacheDirectiveLock(long id, String path, String pool, int maxNumResults) {
        this.lockType = TransactionLockTypes.LockType.READ;
        this.id = id;
        this.poolName = pool;
        this.path = path;
        this.maxNumResults = maxNumResults;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        CacheDirectiveLock.setLockMode((TransactionLockTypes.LockType)this.lockType);
        if (this.maxNumResults > 0) {
            this.listAll();
        } else {
            if (this.id != null) {
                this.directives = new ArrayList<CacheDirective>(1);
                this.directives.add((CacheDirective)EntityManager.find((FinderType)CacheDirective.Finder.ById, (Object[])new Object[]{this.id}));
            }
            if (this.poolName != null) {
                EntityManager.findList((FinderType)CacheDirective.Finder.ByPoolName, (Object[])new Object[]{this.poolName});
            }
        }
    }

    private void listAll() throws TransactionContextException, StorageException {
        this.directives = (List)EntityManager.findList((FinderType)CacheDirective.Finder.ByIdPoolAndPath, (Object[])new Object[]{this.id, this.poolName, this.path, this.maxNumResults});
    }

    protected Lock.Type getType() {
        return Lock.Type.cacheDirective;
    }

    public List<CacheDirective> getDirectives() {
        return this.directives;
    }
}

