/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.InvalidateBlockDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.util.Slicer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;

public class DatanodeStorageInfo {
    public static final Log LOG = LogFactory.getLog(DatanodeStorageInfo.class);
    public static final DatanodeStorageInfo[] EMPTY_ARRAY = new DatanodeStorageInfo[0];
    public static int BLOCKITERATOR_BATCH_SIZE = 500;
    private final DatanodeDescriptor dn;
    private final String storageID;
    private StorageType storageType;
    private DatanodeStorage.State state;
    private long capacity;
    private long dfsUsed;
    private volatile long remaining;
    private long blockPoolUsed;
    private int sid = -1;
    private long lastBlockReportId = 0L;
    private int blockReportCount = 0;
    private boolean heartbeatedSinceFailover = false;
    private boolean blockContentsStale = true;

    public static StorageType[] toStorageTypes(DatanodeStorageInfo[] storages) {
        StorageType[] storageTypes = new StorageType[storages.length];
        for (int i = 0; i < storageTypes.length; ++i) {
            storageTypes[i] = storages[i].getStorageType();
        }
        return storageTypes;
    }

    static Iterable<StorageType> toStorageTypes(final Iterable<DatanodeStorageInfo> infos) {
        return new Iterable<StorageType>(){

            @Override
            public Iterator<StorageType> iterator() {
                return new Iterator<StorageType>(){
                    final Iterator<DatanodeStorageInfo> i;
                    {
                        this.i = infos.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public StorageType next() {
                        return this.i.next().getStorageType();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static String[] toStorageIDs(DatanodeStorageInfo[] storages) {
        String[] storageIDs = new String[storages.length];
        for (int i = 0; i < storageIDs.length; ++i) {
            storageIDs[i] = storages[i].getStorageID();
        }
        return storageIDs;
    }

    public static DatanodeInfo[] toDatanodeInfos(DatanodeStorageInfo[] storages) {
        return DatanodeStorageInfo.toDatanodeInfos(Arrays.asList(storages));
    }

    public static DatanodeInfo[] toDatanodeInfos(List<DatanodeStorageInfo> storages) {
        DatanodeInfo[] datanodes = new DatanodeInfo[storages.size()];
        for (int i = 0; i < storages.size(); ++i) {
            datanodes[i] = storages.get(i).getDatanodeDescriptor();
        }
        return datanodes;
    }

    static DatanodeDescriptor[] toDatanodeDescriptors(DatanodeStorageInfo[] storages) {
        DatanodeDescriptor[] datanodes = new DatanodeDescriptor[storages.length];
        for (int i = 0; i < storages.length; ++i) {
            datanodes[i] = storages[i].getDatanodeDescriptor();
        }
        return datanodes;
    }

    public DatanodeStorageInfo(DatanodeDescriptor dn, DatanodeStorage s) {
        this.dn = dn;
        this.storageID = s.getStorageID();
        this.storageType = s.getStorageType();
        this.state = s.getState();
    }

    int getBlockReportCount() {
        return this.blockReportCount;
    }

    void setBlockReportCount(int blockReportCount) {
        this.blockReportCount = blockReportCount;
    }

    public boolean areBlockContentsStale() {
        return this.blockContentsStale;
    }

    void markStaleAfterFailover() {
        this.heartbeatedSinceFailover = false;
        this.blockContentsStale = true;
    }

    void receivedHeartbeat(StorageReport report) {
        this.updateState(report);
        this.heartbeatedSinceFailover = true;
    }

    void receivedBlockReport() {
        if (this.heartbeatedSinceFailover) {
            this.blockContentsStale = false;
        }
        ++this.blockReportCount;
    }

    @VisibleForTesting
    public void setUtilization(long capacity, long dfsUsed, long remaining) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
    }

    public Iterator<BlockInfoContiguous> getBlockIterator(int startIndex) throws IOException {
        return new BlockIterator(startIndex);
    }

    private List<BlockInfoContiguous> getStorageBlockInfos(final long from, final int size) throws IOException {
        final int sid = this.sid;
        LightWeightRequestHandler findBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_IDS){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws StorageException, IOException {
                boolean transactionActive = connector.isTransactionActive();
                try {
                    if (!transactionActive) {
                        connector.beginTransaction();
                    }
                    BlockInfoDataAccess da = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                    List list = da.findBlockInfosByStorageId(sid, from, size);
                    return list;
                }
                finally {
                    if (!transactionActive) {
                        connector.commit();
                    }
                }
            }
        };
        return (List)findBlocksHandler.handle();
    }

    private long getStartBlockId(final long index) throws IOException {
        final int sid = this.sid;
        LightWeightRequestHandler findBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_IDS){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws StorageException, IOException {
                boolean transactionActive = connector.isTransactionActive();
                try {
                    if (!transactionActive) {
                        connector.beginTransaction();
                    }
                    ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                    Long l = da.findBlockIdAtIndex(sid, index, BLOCKITERATOR_BATCH_SIZE);
                    return l;
                }
                finally {
                    if (!transactionActive) {
                        connector.commit();
                    }
                }
            }
        };
        return (Long)findBlocksHandler.handle();
    }

    private boolean hasBlocksWithIdGreaterThan(final long from) throws IOException {
        final int sid = this.sid;
        LightWeightRequestHandler hasBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_IDS){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws StorageException, IOException {
                boolean transactionActive = connector.isTransactionActive();
                try {
                    if (!transactionActive) {
                        connector.beginTransaction();
                    }
                    ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                    Boolean bl = da.hasBlocksWithIdGreaterThan(sid, from);
                    return bl;
                }
                finally {
                    if (!transactionActive) {
                        connector.commit();
                    }
                }
            }
        };
        return (Boolean)hasBlocksHandler.handle();
    }

    long getLastBlockReportId() {
        return this.lastBlockReportId;
    }

    void setLastBlockReportId(long lastBlockReportId) {
        this.lastBlockReportId = lastBlockReportId;
    }

    public DatanodeStorage.State getState() {
        return this.state;
    }

    public void setState(DatanodeStorage.State s) {
        this.state = s;
    }

    boolean areBlocksOnFailedStorage() throws IOException {
        return this.getState() == DatanodeStorage.State.FAILED && this.numBlocks() != 0;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getSid() {
        return this.sid;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getDfsUsed() {
        return this.dfsUsed;
    }

    public long getRemaining() {
        return this.remaining;
    }

    long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    public void updateFromStorage(DatanodeStorage storage) {
        this.state = storage.getState();
        this.storageType = storage.getStorageType();
    }

    public AddBlockResult addBlock(BlockInfoContiguous b) throws TransactionContextException, StorageException {
        AddBlockResult result = AddBlockResult.ADDED;
        Integer otherStorage = b.getReplicatedOnDatanode(this.getDatanodeDescriptor());
        if (otherStorage != null) {
            if (otherStorage != this.sid) {
                b.removeReplica(otherStorage);
                result = AddBlockResult.REPLACED;
            } else {
                return AddBlockResult.ALREADY_EXIST;
            }
        }
        b.addStorage(this);
        return result;
    }

    public boolean removeBlock(BlockInfoContiguous b) throws TransactionContextException, StorageException {
        return b.removeReplica(this) != null;
    }

    public int numBlocks() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_REPLICAS_ON_NODE){

            public Object performTask() throws StorageException, IOException {
                ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                return da.countAllReplicasForStorageId(DatanodeStorageInfo.this.getSid());
            }
        }.handle();
    }

    public void updateState(StorageReport r) {
        this.capacity = r.getCapacity();
        this.dfsUsed = r.getDfsUsed();
        this.remaining = r.getRemaining();
        this.blockPoolUsed = r.getBlockPoolUsed();
    }

    public DatanodeDescriptor getDatanodeDescriptor() {
        return this.dn;
    }

    public static void incrementBlocksScheduled(DatanodeStorageInfo ... storages) {
        for (DatanodeStorageInfo s : storages) {
            s.getDatanodeDescriptor().incrementBlocksScheduled(s.getStorageType());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DatanodeStorageInfo)) {
            return false;
        }
        DatanodeStorageInfo that = (DatanodeStorageInfo)obj;
        return this.storageID.equals(that.storageID);
    }

    public int hashCode() {
        return this.storageID.hashCode();
    }

    public String toString() {
        return "[" + this.storageType + "]" + this.storageID + ":" + (Object)((Object)this.state) + ":" + (Object)((Object)this.dn);
    }

    StorageReport toStorageReport() {
        return new StorageReport(new DatanodeStorage(this.storageID, this.state, this.storageType), false, this.capacity, this.dfsUsed, this.remaining, this.blockPoolUsed);
    }

    public Map<Long, Long> getAllStorageReplicas(int numBuckets, int nbThreads, int bucketPerThread, ExecutorService executor) throws IOException {
        return DatanodeStorageInfo.getAllStorageReplicas(numBuckets, this.sid, nbThreads, bucketPerThread, executor);
    }

    public static Map<Long, Long> getAllStorageReplicas(int numBuckets, final int sid, int nbThreads, int bucketPerThread, ExecutorService executor) throws IOException {
        final ConcurrentHashMap<Long, Long> result = new ConcurrentHashMap<Long, Long>();
        try {
            Slicer.slice((int)numBuckets, (int)bucketPerThread, (int)nbThreads, (ExecutorService)executor, (Slicer.OperationHandler)new Slicer.OperationHandler(){

                public void handle(int startIndex, int endIndex) throws Exception {
                    LOG.debug((Object)("get blocks in buckets " + startIndex + " to " + endIndex + " for storage " + sid));
                    final ArrayList<Integer> buckets = new ArrayList<Integer>();
                    for (int i = startIndex; i < endIndex; ++i) {
                        buckets.add(i);
                    }
                    LightWeightRequestHandler findBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_BLOCKS_IDS){

                        public Object performTask() throws StorageException, IOException {
                            ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                            return da.findBlockAndInodeIdsByStorageIdAndBucketIds(sid, buckets);
                        }
                    };
                    result.putAll((Map)findBlocksHandler.handle());
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        return result;
    }

    public Map<Long, Long> getAllStorageReplicasInBuckets(final List<Integer> mismatchedBuckets) throws IOException {
        LightWeightRequestHandler findReplicasHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_BLOCKS_IN_BUCKETS){

            public Object performTask() throws IOException {
                ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                return da.findBlockAndInodeIdsByStorageIdAndBucketIds(DatanodeStorageInfo.this.sid, mismatchedBuckets);
            }
        };
        return (Map)findReplicasHandler.handle();
    }

    public Map<Long, Long> getAllStorageInvalidatedReplicasWithGenStamp() throws IOException {
        LightWeightRequestHandler findBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_BLOCKS_IDS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                return da.findInvalidatedBlockBySidUsingMySQLServer(DatanodeStorageInfo.this.getSid());
            }
        };
        return (Map)findBlocksHandler.handle();
    }

    @VisibleForTesting
    public void setUtilizationForTesting(long capacity, long dfsUsed, long remaining, long blockPoolUsed) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.blockPoolUsed = blockPoolUsed;
    }

    static DatanodeStorageInfo getDatanodeStorageInfo(Iterable<DatanodeStorageInfo> infos, DatanodeDescriptor datanode) {
        if (datanode == null) {
            return null;
        }
        for (DatanodeStorageInfo storage : infos) {
            if (storage.getDatanodeDescriptor() != datanode) continue;
            return storage;
        }
        return null;
    }

    static enum AddBlockResult {
        ADDED,
        REPLACED,
        ALREADY_EXIST;

    }

    private class BlockIterator
    implements Iterator<BlockInfoContiguous> {
        private Iterator<BlockInfoContiguous> blocks = Collections.EMPTY_LIST.iterator();
        long index = 0L;

        public BlockIterator(int startIndex) throws IOException {
            this.index = DatanodeStorageInfo.this.getStartBlockId(startIndex);
        }

        @Override
        public boolean hasNext() {
            if (!this.blocks.hasNext()) {
                this.update();
            }
            return this.blocks.hasNext();
        }

        @Override
        public BlockInfoContiguous next() {
            if (!this.blocks.hasNext()) {
                this.update();
            }
            return this.blocks.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove unsupported.");
        }

        private void update() {
            try {
                List list = null;
                while (!this.blocks.hasNext() && DatanodeStorageInfo.this.hasBlocksWithIdGreaterThan(this.index)) {
                    list = DatanodeStorageInfo.this.getStorageBlockInfos(this.index, BLOCKITERATOR_BATCH_SIZE);
                    this.blocks = list.iterator();
                    this.index = Math.max(((BlockInfoContiguous)((Object)list.get(list.size() - 1))).getBlockId() + 1L, this.index + (long)BLOCKITERATOR_BATCH_SIZE);
                }
                int n = list != null ? list.size() : 0;
            }
            catch (IOException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
    }
}

