/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.util;

import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.cglib.proxy.Callback;
import io.hops.hadoop.shaded.org.mockito.cglib.proxy.Enhancer;
import io.hops.hadoop.shaded.org.mockito.cglib.proxy.Factory;
import io.hops.hadoop.shaded.org.mockito.exceptions.misusing.NotAMockException;
import io.hops.hadoop.shaded.org.mockito.internal.MockHandler;
import io.hops.hadoop.shaded.org.mockito.internal.MockHandlerInterface;
import io.hops.hadoop.shaded.org.mockito.internal.creation.MethodInterceptorFilter;
import io.hops.hadoop.shaded.org.mockito.internal.creation.MockSettingsImpl;
import io.hops.hadoop.shaded.org.mockito.internal.creation.jmock.ClassImposterizer;
import io.hops.hadoop.shaded.org.mockito.internal.util.ArrayUtils;
import io.hops.hadoop.shaded.org.mockito.internal.util.MockCreationValidator;
import io.hops.hadoop.shaded.org.mockito.internal.util.MockName;
import io.hops.hadoop.shaded.org.mockito.internal.util.reflection.LenientCopyTool;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockUtil {
    private final MockCreationValidator creationValidator;

    public MockUtil(MockCreationValidator creationValidator) {
        this.creationValidator = creationValidator;
    }

    public MockUtil() {
        this(new MockCreationValidator());
    }

    public <T> T createMock(Class<T> classToMock, MockSettingsImpl settings) {
        Class<?>[] ancillaryTypes;
        this.creationValidator.validateType(classToMock);
        this.creationValidator.validateExtraInterfaces(classToMock, settings.getExtraInterfaces());
        this.creationValidator.validateMockedType(classToMock, settings.getSpiedInstance());
        settings.initiateMockName(classToMock);
        MockHandler mockHandler = new MockHandler(settings);
        MethodInterceptorFilter filter = new MethodInterceptorFilter(mockHandler, settings);
        Class<?>[] interfaces = settings.getExtraInterfaces();
        if (settings.isSerializable()) {
            Class[] classArray;
            if (interfaces == null) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Serializable.class;
            } else {
                classArray = new ArrayUtils().concat(interfaces, Serializable.class);
            }
            ancillaryTypes = classArray;
        } else {
            ancillaryTypes = interfaces == null ? new Class[]{} : interfaces;
        }
        Object spiedInstance = settings.getSpiedInstance();
        T mock = ClassImposterizer.INSTANCE.imposterise(filter, classToMock, ancillaryTypes);
        if (spiedInstance != null) {
            new LenientCopyTool().copyToMock(spiedInstance, mock);
        }
        return mock;
    }

    public <T> void resetMock(T mock) {
        MockHandlerInterface<T> oldMockHandler = this.getMockHandler(mock);
        MockHandler<T> newMockHandler = new MockHandler<T>(oldMockHandler);
        MethodInterceptorFilter newFilter = new MethodInterceptorFilter(newMockHandler, (MockSettingsImpl)Mockito.withSettings().defaultAnswer(Mockito.RETURNS_DEFAULTS));
        ((Factory)mock).setCallback(0, newFilter);
    }

    public <T> MockHandlerInterface<T> getMockHandler(T mock) {
        if (mock == null) {
            throw new NotAMockException("Argument should be a mock, but is null!");
        }
        if (this.isMockitoMock(mock)) {
            return (MockHandlerInterface)((Object)this.getInterceptor(mock).getHandler());
        }
        throw new NotAMockException("Argument should be a mock, but is: " + mock.getClass());
    }

    private <T> boolean isMockitoMock(T mock) {
        return Enhancer.isEnhanced(mock.getClass()) && this.getInterceptor(mock) != null;
    }

    public boolean isMock(Object mock) {
        return mock != null && this.isMockitoMock(mock);
    }

    private <T> MethodInterceptorFilter getInterceptor(T mock) {
        Factory factory = (Factory)mock;
        Callback callback = factory.getCallback(0);
        if (callback instanceof MethodInterceptorFilter) {
            return (MethodInterceptorFilter)callback;
        }
        return null;
    }

    public MockName getMockName(Object mock) {
        return this.getMockHandler(mock).getMockSettings().getMockName();
    }
}

