/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.exception.StorageException;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.hadoop.hdfs.NoAliveNamenodeException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;

public class ExceptionCheck {
    public static boolean isLocalConnectException(Exception e) {
        return e instanceof ConnectException || e instanceof SocketException || e instanceof BindException || e instanceof UnknownHostException || e instanceof SocketTimeoutException || e instanceof NoRouteToHostException || e instanceof IOException && e.getMessage().contains("Failed on local exception") || e instanceof NoAliveNamenodeException || e instanceof EOFException && e.getMessage().contains("End of File Exception between local host is");
    }

    public static boolean isRetriableException(Exception e) {
        if (e instanceof RemoteException) {
            Exception unwrappedException = ((RemoteException)((Object)e)).unwrapRemoteException();
            if (unwrappedException instanceof RemoteException) {
                unwrappedException = new RemoteRuntimeException((RemoteException)((Object)e)).unwrapRemoteRuntimeException();
            }
            if (unwrappedException != null && !(unwrappedException instanceof RemoteException) && (unwrappedException instanceof StorageException || unwrappedException instanceof RetriableException)) {
                return true;
            }
        }
        return false;
    }

    private static class RemoteRuntimeException
    extends RemoteException {
        public RemoteRuntimeException(RemoteException re) {
            this(re.getClassName(), re.getMessage());
        }

        public RemoteRuntimeException(String className, String msg) {
            super(className, msg);
        }

        public RuntimeException unwrapRemoteRuntimeException() {
            try {
                Class<?> realClass = Class.forName(this.getClassName());
                return this.instantiateRuntimeExceptionException(realClass.asSubclass(RuntimeException.class));
            }
            catch (Exception exception) {
                return null;
            }
        }

        private RuntimeException instantiateRuntimeExceptionException(Class<? extends RuntimeException> cls) throws Exception {
            Constructor<? extends RuntimeException> cn = cls.getConstructor(String.class);
            cn.setAccessible(true);
            RuntimeException ex = cn.newInstance(this.getMessage());
            ex.initCause((Throwable)((Object)this));
            return ex;
        }
    }
}

