/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractOptions;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFSContractTestBase
extends Assert
implements ContractOptions {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFSContractTestBase.class);
    public static final int TEST_FILE_LEN = 1024;
    public static final int DEFAULT_TEST_TIMEOUT = 180000;
    private AbstractFSContract contract;
    private FileSystem fileSystem;
    private Path testPath;
    @Rule
    public TestName methodName = new TestName();
    @Rule
    public Timeout testTimeout = new Timeout(this.getTestTimeoutMillis());

    @BeforeClass
    public static void nameTestThread() {
        Thread.currentThread().setName("JUnit");
    }

    protected abstract AbstractFSContract createContract(Configuration var1);

    protected AbstractFSContract getContract() {
        return this.contract;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public static Logger getLogger() {
        return LOG;
    }

    protected void skipIfUnsupported(String feature) throws IOException {
        if (!this.isSupported(feature)) {
            ContractTestUtils.skip("Skipping as unsupported feature: " + feature);
        }
    }

    protected boolean isSupported(String feature) throws IOException {
        return this.contract.isSupported(feature, false);
    }

    protected void assumeEnabled() {
        if (!this.contract.isEnabled()) {
            throw new AssumptionViolatedException("test cases disabled for " + (Object)((Object)this.contract));
        }
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    protected int getTestTimeoutMillis() {
        return 180000;
    }

    @Before
    public void setup() throws Exception {
        LOG.debug("== Setup ==");
        this.contract = this.createContract(this.createConfiguration());
        this.contract.init();
        this.assumeEnabled();
        this.fileSystem = this.contract.getTestFileSystem();
        AbstractFSContractTestBase.assertNotNull((String)"null filesystem", (Object)this.fileSystem);
        URI fsURI = this.fileSystem.getUri();
        LOG.info("Test filesystem = {} implemented by {}", (Object)fsURI, (Object)this.fileSystem);
        AbstractFSContractTestBase.assertEquals((String)("wrong filesystem of " + fsURI), (Object)this.contract.getScheme(), (Object)fsURI.getScheme());
        this.testPath = this.getContract().getTestPath();
        this.mkdirs(this.testPath);
        LOG.debug("== Setup complete ==");
    }

    @After
    public void teardown() throws Exception {
        LOG.debug("== Teardown ==");
        this.deleteTestDirInTeardown();
        LOG.debug("== Teardown complete ==");
    }

    protected void deleteTestDirInTeardown() throws IOException {
        ContractTestUtils.cleanup("TEARDOWN", this.getFileSystem(), this.testPath);
    }

    protected Path path(String filepath) throws IOException {
        return this.getFileSystem().makeQualified(new Path(this.getContract().getTestPath(), filepath));
    }

    protected Path absolutepath(String filepath) throws IOException {
        return this.getFileSystem().makeQualified(new Path(filepath));
    }

    protected String ls(Path path) throws IOException {
        return ContractTestUtils.ls(this.fileSystem, path);
    }

    protected void describe(String text) {
        LOG.info(text);
    }

    protected void handleRelaxedException(String action, String expectedException, Exception e) throws Exception {
        if (this.getContract().isSupported("supports-strict-exceptions", false)) {
            throw e;
        }
        LOG.warn("The expected exception {}  was not the exception class raised on {}: {}", new Object[]{action, e.getClass(), expectedException, e});
    }

    protected void handleExpectedException(Exception e) {
        AbstractFSContractTestBase.getLogger().debug("expected :{}", (Object)e, (Object)e);
    }

    public void assertPathExists(String message, Path path) throws IOException {
        ContractTestUtils.assertPathExists(this.fileSystem, message, path);
    }

    public void assertPathDoesNotExist(String message, Path path) throws IOException {
        ContractTestUtils.assertPathDoesNotExist(this.fileSystem, message, path);
    }

    protected void assertIsFile(Path filename) throws IOException {
        ContractTestUtils.assertIsFile(this.fileSystem, filename);
    }

    protected void assertIsDirectory(Path path) throws IOException {
        ContractTestUtils.assertIsDirectory(this.fileSystem, path);
    }

    protected void mkdirs(Path path) throws IOException {
        AbstractFSContractTestBase.assertTrue((String)("Failed to mkdir " + path), (boolean)this.fileSystem.mkdirs(path));
    }

    protected void assertDeleted(Path path, boolean recursive) throws IOException {
        ContractTestUtils.assertDeleted(this.fileSystem, path, recursive);
    }

    protected void assertMinusOne(String text, int result) {
        AbstractFSContractTestBase.assertEquals((String)(text + " wrong read result " + result), (long)-1L, (long)result);
    }

    protected boolean rename(Path src, Path dst) throws IOException {
        return this.getFileSystem().rename(src, dst);
    }

    protected String generateAndLogErrorListing(Path src, Path dst) throws IOException {
        FileSystem fs = this.getFileSystem();
        AbstractFSContractTestBase.getLogger().error("src dir " + ContractTestUtils.ls(fs, src.getParent()));
        String destDirLS = ContractTestUtils.ls(fs, dst.getParent());
        if (fs.isDirectory(dst)) {
            destDirLS = destDirLS + "\n" + ContractTestUtils.ls(fs, dst);
        }
        return destDirLS;
    }
}

