/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.InMemoryConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;

public final class YarnConfigurationStoreFactory {
    private static final Log LOG = LogFactory.getLog(YarnConfigurationStoreFactory.class);

    private YarnConfigurationStoreFactory() {
    }

    public static YarnConfigurationStore getStore(Configuration conf) {
        Class storeClass = conf.getClass("yarn.scheduler.configuration.store.class", InMemoryConfigurationStore.class, YarnConfigurationStore.class);
        LOG.info((Object)("Using YarnConfigurationStore implementation - " + storeClass));
        return (YarnConfigurationStore)ReflectionUtils.newInstance((Class)storeClass, (Configuration)conf);
    }
}

