/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.znerd.xmlenc;

import io.hops.hadoop.shaded.org.znerd.xmlenc.InvalidXMLException;

public final class XMLChecker {
    public static final void checkS(String string) throws NullPointerException {
        XMLChecker.checkS(string.toCharArray(), 0, string.length());
    }

    public static final void checkS(char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException {
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid for the 'S' production (white space).");
        }
    }

    public static final boolean isName(String string) throws NullPointerException {
        try {
            XMLChecker.checkName(string);
            return true;
        }
        catch (InvalidXMLException invalidXMLException) {
            return false;
        }
    }

    public static final void checkName(String string) throws NullPointerException, InvalidXMLException {
        XMLChecker.checkName(string.toCharArray(), 0, string.length());
    }

    public static final void checkName(char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException {
        if (n2 < 1) {
            throw new InvalidXMLException("An empty string does not match the 'Name' production.");
        }
        int n3 = n;
        char c = cArray[n3];
        if (c != '_' && c != ':' && !XMLChecker.isLetter(c)) {
            throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is invalid as a starting character in the 'Name' production.");
        }
        ++n3;
        while (n3 < n2) {
            c = cArray[n3];
            if (!XMLChecker.isNameChar(c)) {
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid for the 'Name' production.");
            }
            ++n3;
        }
    }

    public static final boolean isSystemLiteral(String string) throws NullPointerException {
        try {
            XMLChecker.checkSystemLiteral(string);
            return true;
        }
        catch (InvalidXMLException invalidXMLException) {
            return false;
        }
    }

    public static final void checkSystemLiteral(String string) throws NullPointerException, InvalidXMLException {
        XMLChecker.checkSystemLiteral(string.toCharArray(), 0, string.length());
    }

    public static final void checkSystemLiteral(char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException {
        String string;
        if (n2 < 3) {
            throw new InvalidXMLException("Minimum length for the 'SystemLiteral' production is 3 characters.");
        }
        int n3 = n + n2 - 1;
        char c = cArray[0];
        char c2 = cArray[n3];
        if (c == '\'') {
            if (c2 != '\'') {
                throw new InvalidXMLException("First character is '\\'', but the last character is 0x" + Integer.toHexString(c2) + '.');
            }
            string = "-()+,./:=?;!*#@$_%";
        } else if (c == '\"') {
            if (c2 != '\"') {
                throw new InvalidXMLException("First character is '\"', but the last character is 0x" + Integer.toHexString(c2) + '.');
            }
            string = "-'()+,./:=?;!*#@$_%";
        } else {
            throw new InvalidXMLException("First char must either be '\\'' or '\"' instead of 0x" + Integer.toHexString(c) + '.');
        }
        for (int i = 1; i < n2 - 1; ++i) {
            char c3 = cArray[i];
            if (c3 != c) continue;
            if (c == '\'') {
                throw new InvalidXMLException("Found '\\'' at position " + i + '.');
            }
            throw new InvalidXMLException("Found '\"' at position " + i + '.');
        }
    }

    public static final boolean isPubidLiteral(String string) throws NullPointerException {
        try {
            XMLChecker.checkPubidLiteral(string);
            return true;
        }
        catch (InvalidXMLException invalidXMLException) {
            return false;
        }
    }

    public static final void checkPubidLiteral(String string) throws NullPointerException, InvalidXMLException {
        XMLChecker.checkPubidLiteral(string.toCharArray(), 0, string.length());
    }

    public static final void checkPubidLiteral(char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException {
        String string;
        if (n2 < 3) {
            throw new InvalidXMLException("Minimum length for the 'PubidLiteral' production is 3 characters.");
        }
        int n3 = n + n2 - 1;
        char c = cArray[0];
        char c2 = cArray[n3];
        if (c == '\'') {
            if (c2 != '\'') {
                throw new InvalidXMLException("First character is '\\'', but the last character is 0x" + Integer.toHexString(c2) + '.');
            }
            string = "-()+,./:=?;!*#@$_%";
        } else if (c == '\"') {
            if (c2 != '\"') {
                throw new InvalidXMLException("First character is '\"', but the last character is 0x" + Integer.toHexString(c2) + '.');
            }
            string = "-'()+,./:=?;!*#@$_%";
        } else {
            throw new InvalidXMLException("First char must either be '\\'' or '\"' instead of 0x" + Integer.toHexString(c) + '.');
        }
        for (int i = 1; i < n2 - 1; ++i) {
            char c3 = cArray[i];
            if (c3 == ' ' || c3 == '\r' || c3 == '\n' || XMLChecker.isLetter(c3) || XMLChecker.isDigit(c3) || string.indexOf(c3) >= 0) continue;
            throw new InvalidXMLException("The character '" + c3 + "' (0x" + Integer.toHexString(c3) + ") is not valid for the " + "'PubidLiteral' production.");
        }
    }

    private static final boolean isNameChar(char c) {
        return c == '.' || c == '-' || c == '_' || c == ':' || XMLChecker.isDigit(c) || XMLChecker.isLetter(c) || XMLChecker.isCombiningChar(c) || XMLChecker.isExtender(c);
    }

    private static final boolean isLetter(char c) {
        return XMLChecker.isBaseChar(c) || XMLChecker.isIdeographic(c);
    }

    private static final boolean isBaseChar(char c) {
        char c2 = c;
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '\u00c0' && c2 <= '\u00d6' || c2 >= '\u00d8' && c2 <= '\u00f6' || c2 >= '\u00f8' && c2 <= '\u00ff' || c2 >= '\u0100' && c2 <= '\u0131' || c2 >= '\u0134' && c2 <= '\u013e' || c2 >= '\u0141' && c2 <= '\u0148' || c2 >= '\u014a' && c2 <= '\u017e' || c2 >= '\u0180' && c2 <= '\u01c3' || c2 >= '\u01cd' && c2 <= '\u01f0' || c2 >= '\u01f4' && c2 <= '\u01f5' || c2 >= '\u01fa' && c2 <= '\u0217' || c2 >= '\u0250' && c2 <= '\u02a8' || c2 >= '\u02bb' && c2 <= '\u02c1' || c2 == '\u0386' || c2 >= '\u0388' && c2 <= '\u038a' || c2 == '\u038c' || c2 >= '\u038e' && c2 <= '\u03a1' || c2 >= '\u03a3' && c2 <= '\u03ce' || c2 >= '\u03d0' && c2 <= '\u03d6' || c2 == '\u03da' || c2 == '\u03dc' || c2 == '\u03de' || c2 == '\u03e0' || c2 >= '\u03e2' && c2 <= '\u03f3' || c2 >= '\u0401' && c2 <= '\u040c' || c2 >= '\u040e' && c2 <= '\u044f' || c2 >= '\u0451' && c2 <= '\u045c' || c2 >= '\u045e' && c2 <= '\u0481' || c2 >= '\u0490' && c2 <= '\u04c4' || c2 >= '\u04c7' && c2 <= '\u04c8' || c2 >= '\u04cb' && c2 <= '\u04cc' || c2 >= '\u04d0' && c2 <= '\u04eb' || c2 >= '\u04ee' && c2 <= '\u04f5' || c2 >= '\u04f8' && c2 <= '\u04f9' || c2 >= '\u0531' && c2 <= '\u0556' || c2 == '\u0559' || c2 >= '\u0561' && c2 <= '\u0586' || c2 >= '\u05d0' && c2 <= '\u05ea' || c2 >= '\u05f0' && c2 <= '\u05f2' || c2 >= '\u0621' && c2 <= '\u063a' || c2 >= '\u0641' && c2 <= '\u064a' || c2 >= '\u0671' && c2 <= '\u06b7' || c2 >= '\u06ba' && c2 <= '\u06be' || c2 >= '\u06c0' && c2 <= '\u06ce' || c2 >= '\u06d0' && c2 <= '\u06d3' || c2 == '\u06d5' || c2 >= '\u06e5' && c2 <= '\u06e6' || c2 >= '\u0905' && c2 <= '\u0939' || c2 == '\u093d' || c2 >= '\u0958' && c2 <= '\u0961' || c2 >= '\u0985' && c2 <= '\u098c' || c2 >= '\u098f' && c2 <= '\u0990' || c2 >= '\u0993' && c2 <= '\u09a8' || c2 >= '\u09aa' && c2 <= '\u09b0' || c2 == '\u09b2' || c2 >= '\u09b6' && c2 <= '\u09b9' || c2 >= '\u09dc' && c2 <= '\u09dd' || c2 >= '\u09df' && c2 <= '\u09e1' || c2 >= '\u09f0' && c2 <= '\u09f1' || c2 >= '\u0a05' && c2 <= '\u0a0a' || c2 >= '\u0a0f' && c2 <= '\u0a10' || c2 >= '\u0a13' && c2 <= '\u0a28' || c2 >= '\u0a2a' && c2 <= '\u0a30' || c2 >= '\u0a32' && c2 <= '\u0a33' || c2 >= '\u0a35' && c2 <= '\u0a36' || c2 >= '\u0a38' && c2 <= '\u0a39' || c2 >= '\u0a59' && c2 <= '\u0a5c' || c2 == '\u0a5e' || c2 >= '\u0a72' && c2 <= '\u0a74' || c2 >= '\u0a85' && c2 <= '\u0a8b' || c2 == '\u0a8d' || c2 >= '\u0a8f' && c2 <= '\u0a91' || c2 >= '\u0a93' && c2 <= '\u0aa8' || c2 >= '\u0aaa' && c2 <= '\u0ab0' || c2 >= '\u0ab2' && c2 <= '\u0ab3' || c2 >= '\u0ab5' && c2 <= '\u0ab9' || c2 == '\u0abd' || c2 == '\u0ae0' || c2 >= '\u0b05' && c2 <= '\u0b0c' || c2 >= '\u0b0f' && c2 <= '\u0b10' || c2 >= '\u0b13' && c2 <= '\u0b28' || c2 >= '\u0b2a' && c2 <= '\u0b30' || c2 >= '\u0b32' && c2 <= '\u0b33' || c2 >= '\u0b36' && c2 <= '\u0b39' || c2 == '\u0b3d' || c2 >= '\u0b5c' && c2 <= '\u0b5d' || c2 >= '\u0b5f' && c2 <= '\u0b61' || c2 >= '\u0b85' && c2 <= '\u0b8a' || c2 >= '\u0b8e' && c2 <= '\u0b90' || c2 >= '\u0b92' && c2 <= '\u0b95' || c2 >= '\u0b99' && c2 <= '\u0b9a' || c2 == '\u0b9c' || c2 >= '\u0b9e' && c2 <= '\u0b9f' || c2 >= '\u0ba3' && c2 <= '\u0ba4' || c2 >= '\u0ba8' && c2 <= '\u0baa' || c2 >= '\u0bae' && c2 <= '\u0bb5' || c2 >= '\u0bb7' && c2 <= '\u0bb9' || c2 >= '\u0c05' && c2 <= '\u0c0c' || c2 >= '\u0c0e' && c2 <= '\u0c10' || c2 >= '\u0c12' && c2 <= '\u0c28' || c2 >= '\u0c2a' && c2 <= '\u0c33' || c2 >= '\u0c35' && c2 <= '\u0c39' || c2 >= '\u0c60' && c2 <= '\u0c61' || c2 >= '\u0c85' && c2 <= '\u0c8c' || c2 >= '\u0c8e' && c2 <= '\u0c90' || c2 >= '\u0c92' && c2 <= '\u0ca8' || c2 >= '\u0caa' && c2 <= '\u0cb3' || c2 >= '\u0cb5' && c2 <= '\u0cb9' || c2 == '\u0cde' || c2 >= '\u0ce0' && c2 <= '\u0ce1' || c2 >= '\u0d05' && c2 <= '\u0d0c' || c2 >= '\u0d0e' && c2 <= '\u0d10' || c2 >= '\u0d12' && c2 <= '\u0d28' || c2 >= '\u0d2a' && c2 <= '\u0d39' || c2 >= '\u0d60' && c2 <= '\u0d61' || c2 >= '\u0e01' && c2 <= '\u0e2e' || c2 == '\u0e30' || c2 >= '\u0e32' && c2 <= '\u0e33' || c2 >= '\u0e40' && c2 <= '\u0e45' || c2 >= '\u0e81' && c2 <= '\u0e82' || c2 == '\u0e84' || c2 >= '\u0e87' && c2 <= '\u0e88' || c2 == '\u0e8a' || c2 == '\u0e8d' || c2 >= '\u0e94' && c2 <= '\u0e97' || c2 >= '\u0e99' && c2 <= '\u0e9f' || c2 >= '\u0ea1' && c2 <= '\u0ea3' || c2 == '\u0ea5' || c2 == '\u0ea7' || c2 >= '\u0eaa' && c2 <= '\u0eab' || c2 >= '\u0ead' && c2 <= '\u0eae' || c2 == '\u0eb0' || c2 >= '\u0eb2' && c2 <= '\u0eb3' || c2 == '\u0ebd' || c2 >= '\u0ec0' && c2 <= '\u0ec4' || c2 >= '\u0f40' && c2 <= '\u0f47' || c2 >= '\u0f49' && c2 <= '\u0f69' || c2 >= '\u10a0' && c2 <= '\u10c5' || c2 >= '\u10d0' && c2 <= '\u10f6' || c2 == '\u1100' || c2 >= '\u1102' && c2 <= '\u1103' || c2 >= '\u1105' && c2 <= '\u1107' || c2 == '\u1109' || c2 >= '\u110b' && c2 <= '\u110c' || c2 >= '\u110e' && c2 <= '\u1112' || c2 == '\u113c' || c2 == '\u113e' || c2 == '\u1140' || c2 == '\u114c' || c2 == '\u114e' || c2 == '\u1150' || c2 >= '\u1154' && c2 <= '\u1155' || c2 == '\u1159' || c2 >= '\u115f' && c2 <= '\u1161' || c2 == '\u1163' || c2 == '\u1165' || c2 == '\u1167' || c2 == '\u1169' || c2 >= '\u116d' && c2 <= '\u116e' || c2 >= '\u1172' && c2 <= '\u1173' || c2 == '\u1175' || c2 == '\u119e' || c2 == '\u11a8' || c2 == '\u11ab' || c2 >= '\u11ae' && c2 <= '\u11af' || c2 >= '\u11b7' && c2 <= '\u11b8' || c2 == '\u11ba' || c2 >= '\u11bc' && c2 <= '\u11c2' || c2 == '\u11eb' || c2 == '\u11f0' || c2 == '\u11f9' || c2 >= '\u1e00' && c2 <= '\u1e9b' || c2 >= '\u1ea0' && c2 <= '\u1ef9' || c2 >= '\u1f00' && c2 <= '\u1f15' || c2 >= '\u1f18' && c2 <= '\u1f1d' || c2 >= '\u1f20' && c2 <= '\u1f45' || c2 >= '\u1f48' && c2 <= '\u1f4d' || c2 >= '\u1f50' && c2 <= '\u1f57' || c2 == '\u1f59' || c2 == '\u1f5b' || c2 == '\u1f5d' || c2 >= '\u1f5f' && c2 <= '\u1f7d' || c2 >= '\u1f80' && c2 <= '\u1fb4' || c2 >= '\u1fb6' && c2 <= '\u1fbc' || c2 == '\u1fbe' || c2 >= '\u1fc2' && c2 <= '\u1fc4' || c2 >= '\u1fc6' && c2 <= '\u1fcc' || c2 >= '\u1fd0' && c2 <= '\u1fd3' || c2 >= '\u1fd6' && c2 <= '\u1fdb' || c2 >= '\u1fe0' && c2 <= '\u1fec' || c2 >= '\u1ff2' && c2 <= '\u1ff4' || c2 >= '\u1ff6' && c2 <= '\u1ffc' || c2 == '\u2126' || c2 >= '\u212a' && c2 <= '\u212b' || c2 == '\u212e' || c2 >= '\u2180' && c2 <= '\u2182' || c2 >= '\u3041' && c2 <= '\u3094' || c2 >= '\u30a1' && c2 <= '\u30fa' || c2 >= '\u3105' && c2 <= '\u312c' || c2 >= '\uac00' && c2 <= '\ud7a3';
    }

    private static final boolean isIdeographic(char c) {
        char c2 = c;
        return c2 >= '\u4e00' && c2 <= '\u9fa5' || c2 == '\u3007' || c2 >= '\u3021' && c2 <= '\u3029';
    }

    private static final boolean isCombiningChar(char c) {
        char c2 = c;
        return c2 >= '\u0300' && c2 <= '\u0345' || c2 >= '\u0360' && c2 <= '\u0361' || c2 >= '\u0483' && c2 <= '\u0486' || c2 >= '\u0591' && c2 <= '\u05a1' || c2 >= '\u05a3' && c2 <= '\u05b9' || c2 >= '\u05bb' && c2 <= '\u05bd' || c2 == '\u05bf' || c2 >= '\u05c1' && c2 <= '\u05c2' || c2 == '\u05c4' || c2 >= '\u064b' && c2 <= '\u0652' || c2 == '\u0670' || c2 >= '\u06d6' && c2 <= '\u06dc' || c2 >= '\u06dd' && c2 <= '\u06df' || c2 >= '\u06e0' && c2 <= '\u06e4' || c2 >= '\u06e7' && c2 <= '\u06e8' || c2 >= '\u06ea' && c2 <= '\u06ed' || c2 >= '\u0901' && c2 <= '\u0903' || c2 == '\u093c' || c2 >= '\u093e' && c2 <= '\u094c' || c2 == '\u094d' || c2 >= '\u0951' && c2 <= '\u0954' || c2 >= '\u0962' && c2 <= '\u0963' || c2 >= '\u0981' && c2 <= '\u0983' || c2 == '\u09bc' || c2 == '\u09be' || c2 == '\u09bf' || c2 >= '\u09c0' && c2 <= '\u09c4' || c2 >= '\u09c7' && c2 <= '\u09c8' || c2 >= '\u09cb' && c2 <= '\u09cd' || c2 == '\u09d7' || c2 >= '\u09e2' && c2 <= '\u09e3' || c2 == '\u0a02' || c2 == '\u0a3c' || c2 == '\u0a3e' || c2 == '\u0a3f' || c2 >= '\u0a40' && c2 <= '\u0a42' || c2 >= '\u0a47' && c2 <= '\u0a48' || c2 >= '\u0a4b' && c2 <= '\u0a4d' || c2 >= '\u0a70' && c2 <= '\u0a71' || c2 >= '\u0a81' && c2 <= '\u0a83' || c2 == '\u0abc' || c2 >= '\u0abe' && c2 <= '\u0ac5' || c2 >= '\u0ac7' && c2 <= '\u0ac9' || c2 >= '\u0acb' && c2 <= '\u0acd' || c2 >= '\u0b01' && c2 <= '\u0b03' || c2 == '\u0b3c' || c2 >= '\u0b3e' && c2 <= '\u0b43' || c2 >= '\u0b47' && c2 <= '\u0b48' || c2 >= '\u0b4b' && c2 <= '\u0b4d' || c2 >= '\u0b56' && c2 <= '\u0b57' || c2 >= '\u0b82' && c2 <= '\u0b83' || c2 >= '\u0bbe' && c2 <= '\u0bc2' || c2 >= '\u0bc6' && c2 <= '\u0bc8' || c2 >= '\u0bca' && c2 <= '\u0bcd' || c2 == '\u0bd7' || c2 >= '\u0c01' && c2 <= '\u0c03' || c2 >= '\u0c3e' && c2 <= '\u0c44' || c2 >= '\u0c46' && c2 <= '\u0c48' || c2 >= '\u0c4a' && c2 <= '\u0c4d' || c2 >= '\u0c55' && c2 <= '\u0c56' || c2 >= '\u0c82' && c2 <= '\u0c83' || c2 >= '\u0cbe' && c2 <= '\u0cc4' || c2 >= '\u0cc6' && c2 <= '\u0cc8' || c2 >= '\u0cca' && c2 <= '\u0ccd' || c2 >= '\u0cd5' && c2 <= '\u0cd6' || c2 >= '\u0d02' && c2 <= '\u0d03' || c2 >= '\u0d3e' && c2 <= '\u0d43' || c2 >= '\u0d46' && c2 <= '\u0d48' || c2 >= '\u0d4a' && c2 <= '\u0d4d' || c2 == '\u0d57' || c2 == '\u0e31' || c2 >= '\u0e34' && c2 <= '\u0e3a' || c2 >= '\u0e47' && c2 <= '\u0e4e' || c2 == '\u0eb1' || c2 >= '\u0eb4' && c2 <= '\u0eb9' || c2 >= '\u0ebb' && c2 <= '\u0ebc' || c2 >= '\u0ec8' && c2 <= '\u0ecd' || c2 >= '\u0f18' && c2 <= '\u0f19' || c2 == '\u0f35' || c2 == '\u0f37' || c2 == '\u0f39' || c2 == '\u0f3e' || c2 == '\u0f3f' || c2 >= '\u0f71' && c2 <= '\u0f84' || c2 >= '\u0f86' && c2 <= '\u0f8b' || c2 >= '\u0f90' && c2 <= '\u0f95' || c2 == '\u0f97' || c2 >= '\u0f99' && c2 <= '\u0fad' || c2 >= '\u0fb1' && c2 <= '\u0fb7' || c2 == '\u0fb9' || c2 >= '\u20d0' && c2 <= '\u20dc' || c2 == '\u20e1' || c2 >= '\u302a' && c2 <= '\u302f' || c2 == '\u3099' || c2 == '\u309a';
    }

    private static final boolean isDigit(char c) {
        char c2 = c;
        return c2 >= '0' && c2 <= '9' || c2 >= '\u0660' && c2 <= '\u0669' || c2 >= '\u06f0' && c2 <= '\u06f9' || c2 >= '\u0966' && c2 <= '\u096f' || c2 >= '\u09e6' && c2 <= '\u09ef' || c2 >= '\u0a66' && c2 <= '\u0a6f' || c2 >= '\u0ae6' && c2 <= '\u0aef' || c2 >= '\u0b66' && c2 <= '\u0b6f' || c2 >= '\u0be7' && c2 <= '\u0bef' || c2 >= '\u0c66' && c2 <= '\u0c6f' || c2 >= '\u0ce6' && c2 <= '\u0cef' || c2 >= '\u0d66' && c2 <= '\u0d6f' || c2 >= '\u0e50' && c2 <= '\u0e59' || c2 >= '\u0ed0' && c2 <= '\u0ed9' || c2 >= '\u0f20' && c2 <= '\u0f29';
    }

    private static final boolean isExtender(char c) {
        char c2 = c;
        return c2 == '\u00b7' || c2 == '\u02d0' || c2 == '\u02d1' || c2 == '\u0387' || c2 == '\u0640' || c2 == '\u0e46' || c2 == '\u0ec6' || c2 == '\u3005' || c2 >= '\u3031' && c2 <= '\u3035' || c2 >= '\u309d' && c2 <= '\u309e' || c2 >= '\u30fc' && c2 <= '\u30fe';
    }

    private XMLChecker() {
    }
}

