/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.server.impl.container.filter;

import io.hops.hadoop.shaded.com.sun.jersey.api.core.ResourceConfig;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.uri.UriHelper;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequest;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequestFilter;
import io.hops.hadoop.shaded.javax.ws.rs.WebApplicationException;
import io.hops.hadoop.shaded.javax.ws.rs.core.Context;
import io.hops.hadoop.shaded.javax.ws.rs.core.Response;
import java.net.URI;

public class NormalizeFilter
implements ContainerRequestFilter {
    @Context
    ResourceConfig resourceConfig;

    @Override
    public ContainerRequest filter(ContainerRequest request) {
        URI normalizedUri;
        URI uri;
        if (this.resourceConfig.getFeature("io.hops.hadoop.shaded.com.sun.jersey.config.feature.NormalizeURI") && (uri = request.getRequestUri()) != (normalizedUri = UriHelper.normalize(uri, !this.resourceConfig.getFeature("io.hops.hadoop.shaded.com.sun.jersey.config.feature.CanonicalizeURIPath")))) {
            if (this.resourceConfig.getFeature("io.hops.hadoop.shaded.com.sun.jersey.config.feature.Redirect")) {
                throw new WebApplicationException(Response.temporaryRedirect((URI)normalizedUri).build());
            }
            URI baseUri = UriHelper.normalize(request.getBaseUri(), !this.resourceConfig.getFeature("io.hops.hadoop.shaded.com.sun.jersey.config.feature.CanonicalizeURIPath"));
            request.setUris(baseUri, normalizedUri);
        }
        return request;
    }
}

