/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.HashBucket;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.BlockRelatedLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockWithType;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;

public class HashBucketsLocksAllFileBlocks
extends LockWithType {
    HashBucketsLocksAllFileBlocks() {
        super(Lock.Type.HashBucket);
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        HashBucketsLocksAllFileBlocks.setLockMode((TransactionLockTypes.LockType)TransactionLockTypes.LockType.WRITE);
        if (locks.containsLock(Lock.Type.Replica) || locks.containsLock(Lock.Type.ReplicaUnderConstruction)) {
            Collection<Object> blks = ((BlockRelatedLock)locks.getLock(Lock.Type.Replica)).getBlocks();
            blks.addAll(((BlockRelatedLock)locks.getLock(Lock.Type.ReplicaUnderConstruction)).getBlocks());
            ArrayList<Replica> replicas = new ArrayList<Replica>();
            for (Object blk : blks) {
                Replica replica = (Replica)blk;
                replicas.add(replica);
            }
            Collections.sort(replicas);
            for (Replica replica : replicas) {
                if (EntityManager.find((FinderType)HashBucket.Finder.ByStorageIdAndBucketId, (Object[])new Object[]{replica.getStorageId(), replica.getBucketId()}) != null) continue;
                EntityManager.update((Object)new HashBucket(replica.getStorageId(), replica.getBucketId(), HashBuckets.initalizeHash()));
                LOG.warn((Object)"The accessed bucket had not been initialized. There might be a misconfiguration.");
            }
        }
    }
}

