/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.server.handler;

import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.Handler;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.HandlerContainer;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.HttpChannelState;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.Request;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.handler.ContextHandler;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.handler.HandlerCollection;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.ArrayTernaryTrie;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.ArrayUtil;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.Trie;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.annotation.ManagedObject;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.annotation.ManagedOperation;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ManagedObject(value="Context Handler Collection")
public class ContextHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = Log.getLogger(ContextHandlerCollection.class);
    private final ConcurrentMap<ContextHandler, Handler> _contextBranches = new ConcurrentHashMap<ContextHandler, Handler>();
    private volatile Trie<Map.Entry<String, Branch[]>> _pathBranches;
    private Class<? extends ContextHandler> _contextClass = ContextHandler.class;

    public ContextHandlerCollection() {
        super(true);
    }

    @ManagedOperation(value="update the mapping of context path to context")
    public void mapContexts() {
        ArrayTernaryTrie arrayTernaryTrie;
        this._contextBranches.clear();
        if (this.getHandlers() == null) {
            this._pathBranches = new ArrayTernaryTrie(false, 16);
            return;
        }
        HashMap<String, Branch[]> map = new HashMap<String, Branch[]>();
        for (Handler handler : this.getHandlers()) {
            Branch branch = new Branch(handler);
            for (String contextPath : branch.getContextPaths()) {
                Object[] branches = (Branch[])map.get(contextPath);
                map.put(contextPath, (Branch[])ArrayUtil.addToArray((Object[])branches, (Object)branch, Branch.class));
            }
            for (ContextHandler contextHandler : branch.getContextHandlers()) {
                this._contextBranches.putIfAbsent(contextHandler, branch.getHandler());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Branch[] branches = (Branch[])entry.getValue();
            Branch[] sorted = new Branch[branches.length];
            int i = 0;
            for (Branch branch : branches) {
                if (!branch.hasVirtualHost()) continue;
                sorted[i++] = branch;
            }
            for (Branch branch : branches) {
                if (branch.hasVirtualHost()) continue;
                sorted[i++] = branch;
            }
            entry.setValue(sorted);
        }
        int capacity = 512;
        block6: while (true) {
            arrayTernaryTrie = new ArrayTernaryTrie(false, capacity);
            for (Map.Entry entry : map.entrySet()) {
                if (arrayTernaryTrie.put(((String)entry.getKey()).substring(1), entry)) continue;
                capacity += 512;
                continue block6;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            for (String ctx : arrayTernaryTrie.keySet()) {
                LOG.debug("{}->{}", new Object[]{ctx, Arrays.asList((Branch[])((Map.Entry)arrayTernaryTrie.get(ctx)).getValue())});
            }
        }
        this._pathBranches = arrayTernaryTrie;
    }

    @Override
    public void setHandlers(Handler[] handlers) {
        super.setHandlers(handlers);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ContextHandler context;
        Handler[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            return;
        }
        HttpChannelState async = baseRequest.getHttpChannelState();
        if (async.isAsync() && (context = async.getContextHandler()) != null) {
            Handler branch = (Handler)this._contextBranches.get(context);
            if (branch == null) {
                context.handle(target, baseRequest, request, response);
            } else {
                branch.handle(target, baseRequest, request, response);
            }
            return;
        }
        if (target.startsWith("/")) {
            Map.Entry branches;
            int limit = target.length() - 1;
            while (limit >= 0 && (branches = (Map.Entry)this._pathBranches.getBest(target, 1, limit)) != null) {
                int l = ((String)branches.getKey()).length();
                if (l == 1 || target.length() == l || target.charAt(l) == '/') {
                    for (Branch branch : (Branch[])branches.getValue()) {
                        branch.getHandler().handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                }
                limit = l - 2;
            }
        } else {
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].handle(target, baseRequest, request, response);
                if (!baseRequest.isHandled()) continue;
                return;
            }
        }
    }

    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            ContextHandler context = this._contextClass.newInstance();
            context.setContextPath(contextPath);
            context.setResourceBase(resourceBase);
            this.addHandler(context);
            return context;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw new Error(e);
        }
    }

    public Class<?> getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class<? extends ContextHandler> contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = contextClass;
    }

    private static final class Branch {
        private final Handler _handler;
        private final ContextHandler[] _contexts;

        Branch(Handler handler) {
            this._handler = handler;
            if (handler instanceof ContextHandler) {
                this._contexts = new ContextHandler[]{(ContextHandler)handler};
            } else if (handler instanceof HandlerContainer) {
                Handler[] contexts = ((HandlerContainer)((Object)handler)).getChildHandlersByClass(ContextHandler.class);
                this._contexts = new ContextHandler[contexts.length];
                System.arraycopy(contexts, 0, this._contexts, 0, contexts.length);
            } else {
                this._contexts = new ContextHandler[0];
            }
        }

        Set<String> getContextPaths() {
            HashSet<String> set = new HashSet<String>();
            for (ContextHandler context : this._contexts) {
                set.add(context.getContextPath());
            }
            return set;
        }

        boolean hasVirtualHost() {
            for (ContextHandler context : this._contexts) {
                if (context.getVirtualHosts() == null || context.getVirtualHosts().length <= 0) continue;
                return true;
            }
            return false;
        }

        ContextHandler[] getContextHandlers() {
            return this._contexts;
        }

        Handler getHandler() {
            return this._handler;
        }

        public String toString() {
            return String.format("{%s,%s}", this._handler, Arrays.asList(this._contexts));
        }
    }
}

