/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.creation;

import io.hops.hadoop.shaded.org.mockito.cglib.proxy.MethodInterceptor;
import io.hops.hadoop.shaded.org.mockito.cglib.proxy.MethodProxy;
import io.hops.hadoop.shaded.org.mockito.internal.MockitoInvocationHandler;
import io.hops.hadoop.shaded.org.mockito.internal.creation.DelegatingMethod;
import io.hops.hadoop.shaded.org.mockito.internal.creation.DelegatingMockitoMethodProxy;
import io.hops.hadoop.shaded.org.mockito.internal.creation.MockSettingsImpl;
import io.hops.hadoop.shaded.org.mockito.internal.creation.MockitoMethodProxy;
import io.hops.hadoop.shaded.org.mockito.internal.creation.SerializableMockitoMethodProxy;
import io.hops.hadoop.shaded.org.mockito.internal.creation.cglib.CGLIBHacker;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.MockitoMethod;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.SerializableMethod;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.realmethod.FilteredCGLIBProxyRealMethod;
import io.hops.hadoop.shaded.org.mockito.internal.progress.SequenceNumber;
import io.hops.hadoop.shaded.org.mockito.internal.util.ObjectMethodsGuru;
import java.io.Serializable;
import java.lang.reflect.Method;

public class MethodInterceptorFilter
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 6182795666612683784L;
    private final MockitoInvocationHandler handler;
    CGLIBHacker cglibHacker = new CGLIBHacker();
    ObjectMethodsGuru objectMethodsGuru = new ObjectMethodsGuru();
    private final MockSettingsImpl mockSettings;

    public MethodInterceptorFilter(MockitoInvocationHandler handler, MockSettingsImpl mockSettings) {
        this.handler = handler;
        this.mockSettings = mockSettings;
    }

    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (this.objectMethodsGuru.isEqualsMethod(method)) {
            return proxy == args[0];
        }
        if (this.objectMethodsGuru.isHashCodeMethod(method)) {
            return this.hashCodeForMock(proxy);
        }
        MockitoMethodProxy mockitoMethodProxy = this.createMockitoMethodProxy(methodProxy);
        this.cglibHacker.setMockitoNamingPolicy(mockitoMethodProxy);
        MockitoMethod mockitoMethod = this.createMockitoMethod(method);
        FilteredCGLIBProxyRealMethod realMethod = new FilteredCGLIBProxyRealMethod(mockitoMethodProxy);
        Invocation invocation = new Invocation(proxy, mockitoMethod, args, SequenceNumber.next(), realMethod);
        return this.handler.handle(invocation);
    }

    public MockitoInvocationHandler getHandler() {
        return this.handler;
    }

    private int hashCodeForMock(Object mock) {
        return System.identityHashCode(mock);
    }

    public MockitoMethodProxy createMockitoMethodProxy(MethodProxy methodProxy) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMockitoMethodProxy(methodProxy);
        }
        return new DelegatingMockitoMethodProxy(methodProxy);
    }

    public MockitoMethod createMockitoMethod(Method method) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMethod(method);
        }
        return new DelegatingMethod(method);
    }
}

