/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CacheDirectiveIteratorForTesting
extends BatchedRemoteIterator<Long, CacheDirectiveEntry> {
    private final CacheDirectiveInfo filter;
    private final ClientProtocol namenode;

    public CacheDirectiveIteratorForTesting(ClientProtocol namenode, CacheDirectiveInfo filter) {
        super((Object)0L);
        this.namenode = namenode;
        this.filter = filter;
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> makeRequest(Long prevKey) throws IOException {
        return this.namenode.listCacheDirectives(prevKey, this.filter);
    }

    public Long elementToPrevKey(CacheDirectiveEntry entry) {
        return entry.getInfo().getId();
    }
}

