/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.executor;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorUtil.class);

    public static void shutdown(ExecutorService executor) {
        executor.shutdown();
        ExecutorUtil.terminate(executor);
    }

    public static void shutdownNow(ExecutorService executor) {
        for (Runnable r : executor.shutdownNow()) {
            if (r instanceof FutureTask && ((FutureTask)r).isCancelled()) continue;
            try {
                r.run();
            }
            catch (Throwable t) {
                LOGGER.warn("Exception executing task left in {}: {}", (Object)executor, (Object)t);
            }
        }
        ExecutorUtil.terminate(executor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void terminate(ExecutorService executor) {
        boolean interrupted = false;
        while (true) {
            try {
                if (executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            catch (Throwable throwable) {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
            {
                LOGGER.warn("Still waiting for termination of {}", (Object)executor);
                continue;
            }
            break;
        }
    }

    public static <T> T waitFor(Future<T> future) throws ExecutionException {
        boolean interrupted = false;
        while (true) {
            try {
                T t = future.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

