/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.http.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public final class FastHttpDateFormat {
    protected static final int CACHE_SIZE = 1000;
    protected static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final ThreadLocal<SimpleDateFormatter> FORMAT = new ThreadLocal<SimpleDateFormatter>(){

        @Override
        protected SimpleDateFormatter initialValue() {
            return new SimpleDateFormatter();
        }
    };
    protected static final ThreadLocal FORMATS = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat[] f = new SimpleDateFormat[3];
            f[0] = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            f[0].setTimeZone(GMT_TIME_ZONE);
            f[1] = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            f[1].setTimeZone(GMT_TIME_ZONE);
            f[2] = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
            f[2].setTimeZone(GMT_TIME_ZONE);
            return f;
        }
    };
    protected static volatile long nextGeneration;
    protected static volatile String currentDate;
    protected static final ConcurrentHashMap<Long, String> formatCache;
    protected static final ConcurrentHashMap<String, Long> parseCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentDate() {
        long now = System.currentTimeMillis();
        if (now > nextGeneration) {
            ThreadLocal<SimpleDateFormatter> threadLocal = FORMAT;
            synchronized (threadLocal) {
                if (now > nextGeneration) {
                    nextGeneration = now + 1000L;
                    currentDate = FORMAT.get().format(now);
                }
            }
        }
        return currentDate;
    }

    public static String formatDate(long value, DateFormat threadLocalFormat) {
        Long longValue = value = value / 1000L * 1000L;
        String cachedDate = formatCache.get(longValue);
        if (cachedDate != null) {
            return cachedDate;
        }
        String newDate = threadLocalFormat != null ? threadLocalFormat.format(value) : FORMAT.get().format(value);
        FastHttpDateFormat.updateFormatCache(longValue, newDate);
        return newDate;
    }

    public static long parseDate(String value, DateFormat[] threadLocalformats) {
        Long cachedDate = parseCache.get(value);
        if (cachedDate != null) {
            return cachedDate;
        }
        long date = threadLocalformats != null ? FastHttpDateFormat.internalParseDate(value, threadLocalformats) : FastHttpDateFormat.internalParseDate(value, (SimpleDateFormat[])FORMATS.get());
        if (date != -1L) {
            FastHttpDateFormat.updateParseCache(value, date);
        }
        return date;
    }

    private static long internalParseDate(String value, DateFormat[] formats) {
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(value).getTime();
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return -1L;
    }

    private static void updateFormatCache(Long key, String value) {
        if (value == null) {
            return;
        }
        if (formatCache.size() > 1000) {
            formatCache.clear();
        }
        formatCache.put(key, value);
    }

    private static void updateParseCache(String key, Long value) {
        if (parseCache.size() > 1000) {
            parseCache.clear();
        }
        parseCache.put(key, value);
    }

    static {
        formatCache = new ConcurrentHashMap(1000, 0.75f, 64);
        parseCache = new ConcurrentHashMap(1000, 0.75f, 64);
    }

    private static final class SimpleDateFormatter {
        private final Date date = new Date();
        private final SimpleDateFormat f = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

        public SimpleDateFormatter() {
            this.f.setTimeZone(GMT_TIME_ZONE);
        }

        public final String format(long timeMillis) {
            this.date.setTime(timeMillis);
            return this.f.format(this.date);
        }
    }
}

