/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import org.apache.hadoop.fs.slive.WeightSelector;

class Weights {
    private Weights() {
    }

    static class BeginWeight
    implements WeightSelector.Weightable {
        BeginWeight() {
        }

        @Override
        public Double weight(int elapsed, int duration) {
            double normalized = (double)elapsed / (double)duration;
            double result = Math.pow(normalized - 1.0, 2.0);
            if (result < 0.0) {
                result = 0.0;
            }
            if (result > 1.0) {
                result = 1.0;
            }
            return result;
        }
    }

    static class EndWeight
    implements WeightSelector.Weightable {
        EndWeight() {
        }

        @Override
        public Double weight(int elapsed, int duration) {
            double normalized = (double)elapsed / (double)duration;
            double result = Math.pow(normalized, 2.0);
            if (result < 0.0) {
                result = 0.0;
            }
            if (result > 1.0) {
                result = 1.0;
            }
            return result;
        }
    }

    static class MidWeight
    implements WeightSelector.Weightable {
        MidWeight() {
        }

        @Override
        public Double weight(int elapsed, int duration) {
            double normalized = (double)elapsed / (double)duration;
            double result = -2.0 * Math.pow(normalized - 0.5, 2.0) + 0.5;
            if (result < 0.0) {
                result = 0.0;
            }
            if (result > 1.0) {
                result = 1.0;
            }
            return result;
        }
    }

    static class UniformWeight
    implements WeightSelector.Weightable {
        private static Double DEFAULT_WEIGHT = 0.3333333333333333;
        private Double weight;

        UniformWeight(double w) {
            this.weight = w;
        }

        UniformWeight() {
            this(DEFAULT_WEIGHT);
        }

        @Override
        public Double weight(int elapsed, int duration) {
            return this.weight;
        }
    }
}

