/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.jsr107;

import io.hops.hadoop.shaded.javax.cache.expiry.ExpiryPolicy;
import io.hops.hadoop.shaded.org.ehcache.ValueSupplier;
import io.hops.hadoop.shaded.org.ehcache.expiry.Duration;
import io.hops.hadoop.shaded.org.ehcache.jsr107.Eh107Expiry;
import java.io.Closeable;
import java.io.IOException;

class ExpiryPolicyToEhcacheExpiry<K, V>
extends Eh107Expiry<K, V>
implements Closeable {
    private final ExpiryPolicy expiryPolicy;

    ExpiryPolicyToEhcacheExpiry(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    public Duration getExpiryForCreation(K key, V value) {
        try {
            io.hops.hadoop.shaded.javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForCreation();
            if (duration.isEternal()) {
                return Duration.INFINITE;
            }
            return new Duration(duration.getDurationAmount(), duration.getTimeUnit());
        }
        catch (Throwable t) {
            return Duration.ZERO;
        }
    }

    @Override
    public Duration getExpiryForAccess(K key, ValueSupplier<? extends V> value) {
        if (this.isShortCircuitAccessCalls()) {
            return null;
        }
        try {
            io.hops.hadoop.shaded.javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForAccess();
            if (duration == null) {
                return null;
            }
            if (duration.isEternal()) {
                return Duration.INFINITE;
            }
            return new Duration(duration.getDurationAmount(), duration.getTimeUnit());
        }
        catch (Throwable t) {
            return Duration.ZERO;
        }
    }

    @Override
    public Duration getExpiryForUpdate(K key, ValueSupplier<? extends V> oldValue, V newValue) {
        try {
            io.hops.hadoop.shaded.javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForUpdate();
            if (duration == null) {
                return null;
            }
            if (duration.isEternal()) {
                return Duration.INFINITE;
            }
            return new Duration(duration.getDurationAmount(), duration.getTimeUnit());
        }
        catch (Throwable t) {
            return Duration.ZERO;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.expiryPolicy instanceof Closeable) {
            ((Closeable)((Object)this.expiryPolicy)).close();
        }
    }
}

