/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.context.extractor;

import io.hops.hadoop.shaded.org.terracotta.context.ContextElement;
import io.hops.hadoop.shaded.org.terracotta.context.annotations.ContextAttribute;
import io.hops.hadoop.shaded.org.terracotta.context.extractor.AttributeGetter;
import io.hops.hadoop.shaded.org.terracotta.context.extractor.DirectAttributeGetter;
import io.hops.hadoop.shaded.org.terracotta.context.extractor.LazyContextElement;
import io.hops.hadoop.shaded.org.terracotta.context.extractor.WeakAttributeGetter;
import io.hops.hadoop.shaded.org.terracotta.context.extractor.WeakFieldAttributeGetter;
import io.hops.hadoop.shaded.org.terracotta.context.extractor.WeakMethodAttributeGetter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ObjectContextExtractor {
    private ObjectContextExtractor() {
    }

    public static ContextElement extract(Object from) {
        HashMap<? extends String, AttributeGetter<? extends Object>> attributes = new HashMap<String, AttributeGetter<? extends Object>>();
        attributes.putAll(ObjectContextExtractor.extractInstanceAttribute(from));
        attributes.putAll(ObjectContextExtractor.extractMethodAttributes(from));
        attributes.putAll(ObjectContextExtractor.extractFieldAttributes(from));
        return new LazyContextElement(from.getClass(), attributes);
    }

    private static Map<? extends String, ? extends AttributeGetter<? extends Object>> extractInstanceAttribute(Object from) {
        ContextAttribute annotation = from.getClass().getAnnotation(ContextAttribute.class);
        if (annotation == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(annotation.value(), new WeakAttributeGetter<Object>(from));
    }

    private static Map<String, AttributeGetter<? extends Object>> extractMethodAttributes(Object from) {
        HashMap<String, AttributeGetter<? extends Object>> attributes = new HashMap<String, AttributeGetter<? extends Object>>();
        for (Method m : from.getClass().getMethods()) {
            ContextAttribute annotation;
            if (m.getParameterTypes().length != 0 || m.getReturnType() == Void.TYPE || (annotation = m.getAnnotation(ContextAttribute.class)) == null) continue;
            attributes.put(annotation.value(), new WeakMethodAttributeGetter(from, m));
        }
        return attributes;
    }

    private static Map<String, AttributeGetter<? extends Object>> extractFieldAttributes(Object from) {
        HashMap<String, AttributeGetter<? extends Object>> attributes = new HashMap<String, AttributeGetter<? extends Object>>();
        for (Class<?> c = from.getClass(); c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                ContextAttribute annotation = f.getAnnotation(ContextAttribute.class);
                if (annotation == null) continue;
                attributes.put(annotation.value(), ObjectContextExtractor.createFieldAttributeGetter(from, f));
            }
        }
        return attributes;
    }

    private static AttributeGetter<? extends Object> createFieldAttributeGetter(Object from, Field f) {
        f.setAccessible(true);
        if (Modifier.isFinal(f.getModifiers())) {
            try {
                return new DirectAttributeGetter<Object>(f.get(from));
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new WeakFieldAttributeGetter(from, f);
    }
}

