/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import java.util.List;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu.GpuResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu.GpuResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.AssignedGpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDiscoverer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDockerCommandPluginFactory;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuNodeResourceUpdateHandler;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NMResourceInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformation;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.NMGpuResourceInfo;

public class GpuResourcePlugin
implements ResourcePlugin {
    private GpuResourceHandlerImpl gpuResourceHandler = null;
    private GpuNodeResourceUpdateHandler resourceDiscoverHandler = null;
    private DockerCommandPlugin dockerCommandPlugin = null;

    @Override
    public synchronized void initialize(Context context) throws YarnException {
        this.resourceDiscoverHandler = new GpuNodeResourceUpdateHandler();
        GpuDiscoverer.getInstance().initialize(context.getConf());
        this.dockerCommandPlugin = GpuDockerCommandPluginFactory.createGpuDockerCommandPlugin(context.getConf());
    }

    @Override
    public synchronized ResourceHandler createResourceHandler(Context context, CGroupsHandler cGroupsHandler, PrivilegedOperationExecutor privilegedOperationExecutor) {
        if (this.gpuResourceHandler == null) {
            this.gpuResourceHandler = new GpuResourceHandlerImpl(context, cGroupsHandler, privilegedOperationExecutor);
        }
        return this.gpuResourceHandler;
    }

    @Override
    public synchronized NodeResourceUpdaterPlugin getNodeResourceHandlerInstance() {
        return this.resourceDiscoverHandler;
    }

    @Override
    public void cleanup() throws YarnException {
    }

    @Override
    public DockerCommandPlugin getDockerCommandPluginInstance() {
        return this.dockerCommandPlugin;
    }

    @Override
    public NMResourceInfo getNMResourceInfo() throws YarnException {
        GpuDeviceInformation gpuDeviceInformation = GpuDiscoverer.getInstance().getGpuDeviceInformation();
        GpuResourceAllocator gpuResourceAllocator = this.gpuResourceHandler.getGpuAllocator();
        List<GpuDevice> totalGpus = gpuResourceAllocator.getAllowedGpusCopy();
        List<AssignedGpuDevice> assignedGpuDevices = gpuResourceAllocator.getAssignedGpusCopy();
        return new NMGpuResourceInfo(gpuDeviceInformation, totalGpus, assignedGpuDevices);
    }
}

