/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.core.config;

import io.hops.hadoop.shaded.org.ehcache.config.CacheConfiguration;
import io.hops.hadoop.shaded.org.ehcache.config.CacheRuntimeConfiguration;
import io.hops.hadoop.shaded.org.ehcache.config.Configuration;
import io.hops.hadoop.shaded.org.ehcache.core.HumanReadable;
import io.hops.hadoop.shaded.org.ehcache.core.internal.util.ClassLoading;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceCreationConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DefaultConfiguration
implements Configuration,
HumanReadable {
    private final ConcurrentMap<String, CacheConfiguration<?, ?>> caches;
    private final Collection<ServiceCreationConfiguration<?>> services;
    private final ClassLoader classLoader;

    public DefaultConfiguration(Configuration cfg) {
        if (cfg.getClassLoader() == null) {
            throw new NullPointerException();
        }
        this.caches = new ConcurrentHashMap(cfg.getCacheConfigurations());
        this.services = Collections.unmodifiableCollection(cfg.getServiceCreationConfigurations());
        this.classLoader = cfg.getClassLoader();
    }

    public DefaultConfiguration(ClassLoader classLoader, ServiceCreationConfiguration<?> ... services) {
        this(DefaultConfiguration.emptyCacheMap(), classLoader, services);
    }

    public DefaultConfiguration(Map<String, CacheConfiguration<?, ?>> caches, ClassLoader classLoader, ServiceCreationConfiguration<?> ... services) {
        this.services = Collections.unmodifiableCollection(Arrays.asList(services));
        this.caches = new ConcurrentHashMap(caches);
        this.classLoader = classLoader == null ? ClassLoading.getDefaultClassLoader() : classLoader;
    }

    @Override
    public Map<String, CacheConfiguration<?, ?>> getCacheConfigurations() {
        return Collections.unmodifiableMap(this.caches);
    }

    @Override
    public Collection<ServiceCreationConfiguration<?>> getServiceCreationConfigurations() {
        return this.services;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private static Map<String, CacheConfiguration<?, ?>> emptyCacheMap() {
        return Collections.emptyMap();
    }

    public void addCacheConfiguration(String alias, CacheConfiguration<?, ?> config) {
        if (this.caches.put(alias, config) != null) {
            throw new IllegalStateException("Cache '" + alias + "' already present!");
        }
    }

    public void removeCacheConfiguration(String alias) {
        this.caches.remove(alias);
    }

    public <K, V> void replaceCacheConfiguration(String alias, CacheConfiguration<K, V> config, CacheRuntimeConfiguration<K, V> runtimeConfiguration) {
        if (!this.caches.replace(alias, config, runtimeConfiguration)) {
            throw new IllegalStateException("The expected configuration doesn't match!");
        }
    }

    @Override
    public String readableString() {
        StringBuilder cachesToStringBuilder = new StringBuilder();
        for (Map.Entry cacheConfigurationEntry : this.caches.entrySet()) {
            if (!(cacheConfigurationEntry.getValue() instanceof HumanReadable)) continue;
            cachesToStringBuilder.append((String)cacheConfigurationEntry.getKey()).append(":\n    ").append(((HumanReadable)cacheConfigurationEntry.getValue()).readableString().replace("\n", "\n    ")).append("\n");
        }
        if (cachesToStringBuilder.length() > 0) {
            cachesToStringBuilder.deleteCharAt(cachesToStringBuilder.length() - 1);
        }
        StringBuilder serviceCreationConfigurationsToStringBuilder = new StringBuilder();
        for (ServiceCreationConfiguration<?> serviceCreationConfiguration : this.services) {
            serviceCreationConfigurationsToStringBuilder.append("- ");
            if (serviceCreationConfiguration instanceof HumanReadable) {
                serviceCreationConfigurationsToStringBuilder.append(((HumanReadable)((Object)serviceCreationConfiguration)).readableString()).append("\n");
                continue;
            }
            serviceCreationConfigurationsToStringBuilder.append(serviceCreationConfiguration.getClass().getName()).append("\n");
        }
        if (serviceCreationConfigurationsToStringBuilder.length() > 0) {
            serviceCreationConfigurationsToStringBuilder.deleteCharAt(serviceCreationConfigurationsToStringBuilder.length() - 1);
        }
        return "caches:\n    " + cachesToStringBuilder.toString().replace("\n", "\n    ") + "\n" + "services: \n    " + serviceCreationConfigurationsToStringBuilder.toString().replace("\n", "\n    ");
    }
}

