/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.statistics;

import io.hops.hadoop.shaded.org.terracotta.statistics.OperationStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.ValueStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.observer.ChainedOperationObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StatisticMapper<SOURCE extends Enum<SOURCE>, TARGET extends Enum<TARGET>>
implements OperationStatistic<TARGET> {
    private final Class<TARGET> targetType;
    private final Class<SOURCE> sourceType;
    private final OperationStatistic<SOURCE> statistic;
    private final Map<TARGET, Set<SOURCE>> translation;
    private final Map<SOURCE, TARGET> reverseTranslation;
    private final ConcurrentMap<ChainedOperationObserver<? super TARGET>, ChainedOperationObserver<SOURCE>> derivedStats = new ConcurrentHashMap<ChainedOperationObserver<? super TARGET>, ChainedOperationObserver<SOURCE>>();

    public StatisticMapper(Map<TARGET, Set<SOURCE>> translation, OperationStatistic<SOURCE> statistic) {
        Map.Entry<TARGET, Set<SOURCE>> first = translation.entrySet().iterator().next();
        this.targetType = ((Enum)first.getKey()).getDeclaringClass();
        this.sourceType = ((Enum)first.getValue().iterator().next()).getDeclaringClass();
        this.statistic = statistic;
        this.translation = translation;
        EnumSet<TARGET> unmappedTierOutcomes = EnumSet.allOf(this.targetType);
        unmappedTierOutcomes.removeAll(translation.keySet());
        if (!unmappedTierOutcomes.isEmpty()) {
            throw new IllegalArgumentException("Translation does not contain target outcomes " + unmappedTierOutcomes);
        }
        this.reverseTranslation = StatisticMapper.reverse(translation);
        EnumSet<SOURCE> unmappedStoreOutcomes = EnumSet.allOf(this.sourceType);
        unmappedStoreOutcomes.removeAll(this.reverseTranslation.keySet());
        if (!unmappedStoreOutcomes.isEmpty()) {
            throw new IllegalArgumentException("Translation does not contain source outcomes " + unmappedStoreOutcomes);
        }
    }

    private static <B extends Enum<B>, A extends Enum<A>> Map<B, A> reverse(Map<A, Set<B>> map) {
        Map<Enum, A> reverse = Collections.emptyMap();
        for (Map.Entry<A, Set<B>> e : map.entrySet()) {
            for (Enum b : e.getValue()) {
                if (reverse.isEmpty()) {
                    reverse = new EnumMap(b.getDeclaringClass());
                }
                if (reverse.put(b, e.getKey()) == null) continue;
                throw new IllegalArgumentException("Reverse statistic outcome mapping is ill-defined: " + map);
            }
        }
        return reverse;
    }

    @Override
    public Class<TARGET> type() {
        return this.targetType;
    }

    @Override
    public ValueStatistic<Long> statistic(TARGET result) {
        return this.statistic.statistic(this.translation.get(result));
    }

    @Override
    public ValueStatistic<Long> statistic(Set<TARGET> results) {
        EnumSet<SOURCE> translated = EnumSet.noneOf(this.sourceType);
        for (Enum result : results) {
            translated.addAll((Collection)this.translation.get(result));
        }
        return this.statistic.statistic((Set<SOURCE>)translated);
    }

    @Override
    public long count(TARGET type) {
        return this.statistic.sum(this.translation.get(type));
    }

    @Override
    public long sum(Set<TARGET> types) {
        EnumSet<SOURCE> translated = EnumSet.noneOf(this.sourceType);
        for (Enum type : types) {
            translated.addAll((Collection)this.translation.get(type));
        }
        return this.statistic.sum(translated);
    }

    @Override
    public long sum() {
        return this.statistic.sum();
    }

    @Override
    public void addDerivedStatistic(final ChainedOperationObserver<? super TARGET> derived) {
        ChainedOperationObserver translator = new ChainedOperationObserver<SOURCE>(){

            @Override
            public void begin(long time) {
                derived.begin(time);
            }

            @Override
            public void end(long time, SOURCE result) {
                derived.end(time, (Enum)StatisticMapper.this.reverseTranslation.get(result));
            }

            @Override
            public void end(long time, SOURCE result, long ... parameters) {
                derived.end(time, (Enum)StatisticMapper.this.reverseTranslation.get(result), parameters);
            }
        };
        if (this.derivedStats.putIfAbsent(derived, translator) == null) {
            this.statistic.addDerivedStatistic(translator);
        }
    }

    @Override
    public void removeDerivedStatistic(ChainedOperationObserver<? super TARGET> derived) {
        ChainedOperationObserver translator = (ChainedOperationObserver)this.derivedStats.remove(derived);
        if (translator != null) {
            this.statistic.removeDerivedStatistic(translator);
        }
    }

    @Override
    public void begin() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void end(TARGET result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void end(TARGET result, long ... parameters) {
        throw new UnsupportedOperationException();
    }
}

