/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.FileProvenanceEntry;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.MetaStatus;
import io.hops.transaction.EntityManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;

public class INodeDirectory
extends INodeWithAdditionalFields {
    protected static final int DEFAULT_FILES_PER_DIRECTORY = 5;
    public static final String ROOT_NAME = "";
    public static final long ROOT_DIR_PARTITION_KEY = 0L;
    public static final short ROOT_DIR_DEPTH = 0;
    private MetaStatus metaStatus = MetaStatus.DISABLED;
    private int childrenNum;
    static final String DUMPTREE_EXCEPT_LAST_ITEM = "+-";
    static final String DUMPTREE_LAST_ITEM = "\\-";

    public static INodeDirectory valueOf(INode inode, Object path) throws FileNotFoundException, PathIsNotDirectoryException {
        if (inode == null) {
            throw new FileNotFoundException("Directory does not exist: " + DFSUtil.path2String(path));
        }
        if (!inode.isDirectory()) {
            throw new PathIsNotDirectoryException(DFSUtil.path2String(path));
        }
        return (INodeDirectory)inode;
    }

    public INodeDirectory(long id, String name, PermissionStatus permissions) throws IOException {
        super(id, name, permissions);
    }

    public INodeDirectory(long id, String name, PermissionStatus permissions, boolean inTree) throws IOException {
        super(id, name, permissions, inTree);
    }

    public INodeDirectory(long id, PermissionStatus permissions, long mTime) throws IOException {
        super(id, permissions, mTime, 0L);
    }

    INodeDirectory(long id, byte[] name, PermissionStatus permissions, long mtime) throws IOException {
        super(id, name, permissions, mtime, 0L, false);
    }

    INodeDirectory(INodeDirectory other) throws IOException {
        this(other, true);
    }

    INodeDirectory(INodeDirectory other, boolean copyFeatures) throws IOException {
        super(other);
        if (copyFeatures) {
            this.features = other.features;
        }
        this.metaStatus = other.getMetaStatus();
    }

    @Override
    public final boolean isDirectory() {
        return true;
    }

    public static INodeDirectory createRootDir(PermissionStatus permissions) throws IOException {
        INodeDirectory newRootINode = new INodeDirectory(1L, ROOT_NAME, permissions);
        newRootINode.inTree();
        newRootINode.setParentIdNoPersistance(0L);
        newRootINode.setPartitionIdNoPersistance(INodeDirectory.getRootDirPartitionKey());
        return newRootINode;
    }

    public static INodeDirectory getRootDir() throws StorageException, TransactionContextException {
        INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{1L});
        return (INodeDirectory)inode;
    }

    void setQuota(BlockStoragePolicySuite bsps, long nsQuota, long ssQuota, QuotaCounts c, StorageType type) throws StorageException, TransactionContextException {
        DirectoryWithQuotaFeature quota = this.getDirectoryWithQuotaFeature();
        if (quota != null) {
            if (type != null) {
                quota.setQuota(ssQuota, type);
            } else {
                quota.setQuota(nsQuota, ssQuota);
            }
        } else {
            DirectoryWithQuotaFeature.Builder builder = new DirectoryWithQuotaFeature.Builder(this.getId()).nameSpaceQuota(nsQuota);
            if (type != null) {
                builder.typeQuota(type, ssQuota);
            } else {
                builder.storageSpaceQuota(ssQuota);
            }
            this.addDirectoryWithQuotaFeature(builder.build(true)).setSpaceConsumed(c);
        }
    }

    @Override
    public QuotaCounts getQuotaCounts() throws StorageException, TransactionContextException {
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        return q != null ? q.getQuota() : super.getQuotaCounts();
    }

    @Override
    public void addSpaceConsumed(QuotaCounts counts, boolean verify) throws QuotaExceededException, StorageException, TransactionContextException {
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        if (q != null) {
            q.addSpaceConsumed(this, counts);
        } else {
            this.addSpaceConsumed2Parent(counts, verify);
        }
    }

    public final DirectoryWithQuotaFeature getDirectoryWithQuotaFeature() throws TransactionContextException, StorageException {
        int i = 0;
        for (INode.Feature f : this.features) {
            if (f instanceof DirectoryWithQuotaFeature) {
                DirectoryWithQuotaFeature feature = (DirectoryWithQuotaFeature)EntityManager.find((FinderType)DirectoryWithQuotaFeature.Finder.ByINodeId, (Object[])new Object[]{this.getId()});
                this.features[i] = feature;
                return feature;
            }
            ++i;
        }
        return null;
    }

    public final boolean isWithQuota() {
        for (INode.Feature f : this.features) {
            if (!(f instanceof DirectoryWithQuotaFeature)) continue;
            return true;
        }
        return false;
    }

    public DirectoryWithQuotaFeature addDirectoryWithQuotaFeature(DirectoryWithQuotaFeature q) throws StorageException, TransactionContextException {
        Preconditions.checkState((!this.isWithQuota() ? 1 : 0) != 0, (Object)"Directory is already with quota");
        this.addFeature(q);
        return q;
    }

    @Override
    public final INodeDirectory asDirectory() {
        return this;
    }

    public boolean isMetaEnabled() {
        return this.metaStatus.isMetaEnabled();
    }

    public MetaStatus getMetaStatus() {
        return this.metaStatus;
    }

    public void setMetaStatus(MetaStatus metaStatus) {
        this.metaStatus = metaStatus;
    }

    public boolean removeChild(INode node) throws IOException {
        INode existingInode = this.getChildINode(node.getLocalNameBytes());
        if (existingInode != null) {
            this.remove(existingInode);
            this.decreaseChildrenNum();
            return true;
        }
        return false;
    }

    void replaceChild(INode newChild) throws StorageException, TransactionContextException {
        INode existingINode = this.getChildINode(newChild.getLocalNameBytes());
        if (existingINode == null) {
            throw new IllegalArgumentException("No child exists to be replaced");
        }
        if (existingINode.getParentId() != newChild.getParentId()) {
            throw new IllegalArgumentException("Invalid parentid");
        }
        short depth = this.myDepth();
        long childPartitionKey = INode.calculatePartitionId(this.getId(), newChild.getLocalName(), (short)(this.myDepth() + 1));
        newChild.setPartitionId(childPartitionKey);
        EntityManager.update((Object)newChild);
    }

    INode getChild(String name) throws StorageException, TransactionContextException {
        return this.getChildINode(DFSUtil.string2Bytes(name));
    }

    public INode getChildINode(byte[] name) throws StorageException, TransactionContextException {
        short myDepth = this.myDepth();
        long childPartitionId = INode.calculatePartitionId(this.getId(), DFSUtil.bytes2String(name), (short)(myDepth + 1));
        INode existingInode = (INode)EntityManager.find((FinderType)INode.Finder.ByNameParentIdAndPartitionId, (Object[])new Object[]{DFSUtil.bytes2String(name), this.getId(), childPartitionId});
        if (existingInode != null && existingInode.isInTree()) {
            return existingInode;
        }
        return null;
    }

    int nextChild(List<INode> children, byte[] name) throws StorageException, TransactionContextException {
        if (name.length == 0) {
            return 0;
        }
        int nextPos = Collections.binarySearch(children, name) + 1;
        if (nextPos >= 0) {
            return nextPos;
        }
        return -nextPos;
    }

    boolean addChild(INode node, boolean setModTime, long namenodeId) throws IOException {
        return this.addChild(node, setModTime, true, namenodeId);
    }

    boolean addChild(INode node, boolean setModTime, boolean logMetadataEvent, long namenodeId) throws IOException {
        INode existingInode = this.getChildINode(node.getLocalNameBytes());
        if (existingInode != null) {
            return false;
        }
        if (!node.isInTree()) {
            node.inTree();
            node.setParentNoPersistance(this);
            short childDepth = (short)(this.myDepth() + 1);
            node.setPartitionIdNoPersistance(INode.calculatePartitionId(node.getParentId(), node.getLocalName(), childDepth));
            EntityManager.add((Object)node);
            this.increaseChildrenNum();
        } else {
            if (node.getParent().getParentId() != this.getId()) {
                this.increaseChildrenNum();
            }
            node.setParent(this);
        }
        if (setModTime) {
            this.setModificationTime(node.getModificationTime());
        }
        if (node.getGroupName() == null) {
            node.setGroup(this.getGroupName());
            node.setGroupID(this.getGroupID());
        }
        if (logMetadataEvent) {
            node.logMetadataEvent(INodeMetadataLogEntry.Operation.Add);
        }
        node.logProvenanceEvent(namenodeId, FileProvenanceEntry.Operation.create());
        return true;
    }

    @Override
    QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, QuotaCounts counts) throws StorageException, TransactionContextException {
        if (this.isWithQuota()) {
            DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
            if (q != null && q.isQuotaSet()) {
                return q.AddCurrentSpaceUsage(counts);
            }
        } else {
            this.computeDirectoryQuotaUsage(bsps, blockStoragePolicyId, counts);
        }
        return counts;
    }

    private QuotaCounts computeDirectoryQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, QuotaCounts counts) throws StorageException, TransactionContextException {
        List<INode> children;
        if (this.isInTree() && (children = this.getChildren()) != null) {
            for (INode child : children) {
                byte childPolicyId = child.getStoragePolicyIDForQuota(blockStoragePolicyId);
                child.computeQuotaUsage(bsps, childPolicyId, counts);
            }
        }
        return this.computeQuotaUsage4CurrentDirectory(bsps, blockStoragePolicyId, counts);
    }

    public QuotaCounts computeQuotaUsage4CurrentDirectory(BlockStoragePolicySuite bsps, byte storagePolicyId, QuotaCounts counts) {
        counts.addNameSpace(1L);
        return counts;
    }

    @Override
    public ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) throws StorageException, TransactionContextException {
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        if (q != null) {
            return q.computeContentSummary(this, summary);
        }
        return this.computeDirectoryContentSummary(summary);
    }

    ContentSummaryComputationContext computeDirectoryContentSummary(ContentSummaryComputationContext summary) throws StorageException, TransactionContextException {
        List<INode> childrenList = this.getChildrenList();
        for (int i = 0; i < childrenList.size(); ++i) {
            INode child = childrenList.get(i);
            byte[] childName = child.getLocalNameBytes();
            long lastYieldCount = summary.getYieldCount();
            child.computeContentSummary(summary);
            if (lastYieldCount == summary.getYieldCount()) continue;
            if (this.getParent() == null) break;
            childrenList = this.getChildrenList();
            i = this.nextChild(childrenList, childName) - 1;
        }
        summary.getCounts().addContent(Content.DIRECTORY, 1L);
        summary.yield();
        return summary;
    }

    public List<INode> getChildrenList() throws StorageException, TransactionContextException {
        List<INode> children = this.getChildren();
        return children == null ? EMPTY_LIST : children;
    }

    private List<INode> getChildren() throws StorageException, TransactionContextException {
        if (!this.isInTree()) {
            return null;
        }
        short childrenDepth = (short)(this.myDepth() + 1);
        if (INode.isTreeLevelRandomPartitioned(childrenDepth)) {
            return (List)EntityManager.findList((FinderType)INode.Finder.ByParentIdFTIS, (Object[])new Object[]{this.getId()});
        }
        return (List)EntityManager.findList((FinderType)INode.Finder.ByParentIdAndPartitionId, (Object[])new Object[]{this.getId(), this.getId()});
    }

    @Override
    public void destroyAndCollectBlocks(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws StorageException, TransactionContextException {
        List<INode> children = this.getChildren();
        if (children != null) {
            for (INode child : children) {
                child.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
            }
        }
        this.parent = null;
        removedINodes.add(this);
    }

    public static long getRootDirPartitionKey() {
        return INode.calculatePartitionId(0L, ROOT_NAME, (short)0);
    }

    public static INodeIdentifier getRootIdentifier() {
        INodeIdentifier rootINodeIdentifier = new INodeIdentifier(Long.valueOf(1L), Long.valueOf(0L), ROOT_NAME, Long.valueOf(INodeDirectory.getRootDirPartitionKey()));
        rootINodeIdentifier.setDepth(Short.valueOf((short)0));
        return rootINodeIdentifier;
    }

    @Override
    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix) throws StorageException, TransactionContextException {
        super.dumpTreeRecursively(out, prefix);
        if (prefix.length() >= 2) {
            prefix.setLength(prefix.length() - 2);
            prefix.append("  ");
        }
        INodeDirectory.dumpTreeRecursively(out, prefix, this.getChildren());
    }

    @VisibleForTesting
    protected static void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, List<? extends INode> subs) throws StorageException, TransactionContextException {
        prefix.append(DUMPTREE_EXCEPT_LAST_ITEM);
        if (subs != null && subs.size() != 0) {
            int i;
            for (i = 0; i < subs.size() - 1; ++i) {
                subs.get(i).dumpTreeRecursively(out, prefix);
                prefix.setLength(prefix.length() - 2);
                prefix.append(DUMPTREE_EXCEPT_LAST_ITEM);
            }
            prefix.setLength(prefix.length() - 2);
            prefix.append(DUMPTREE_LAST_ITEM);
            subs.get(i).dumpTreeRecursively(out, prefix);
        }
        prefix.setLength(prefix.length() - 2);
    }

    @Override
    public INode cloneInode() throws IOException {
        return new INodeDirectory(this, true);
    }

    public int getChildrenNum() {
        return this.childrenNum;
    }

    public void setChildrenNum(int childrenNum) {
        this.childrenNum = childrenNum;
    }

    public void decreaseChildrenNum() throws StorageException, TransactionContextException {
        --this.childrenNum;
        this.save();
    }

    public void increaseChildrenNum() throws StorageException, TransactionContextException {
        ++this.childrenNum;
        this.save();
    }

    @Override
    INodeDirectory getMetaEnabledParent() throws TransactionContextException, StorageException {
        if (this.isMetaEnabled()) {
            return this;
        }
        return super.getMetaEnabledParent();
    }
}

