/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.cedarsoftware.util;

import java.lang.reflect.Array;

public class ArrayUtilities {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    private ArrayUtilities() {
    }

    public static boolean isEmpty(Object array) {
        return array == null || Array.getLength(array) == 0;
    }

    public static int size(Object array) {
        return array == null ? 0 : Array.getLength(array);
    }

    public static Object[] shallowCopy(Object[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static Object[] addAll(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return ArrayUtilities.shallowCopy(array2);
        }
        if (array2 == null) {
            return ArrayUtilities.shallowCopy(array1);
        }
        Object[] newArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static Object removeItem(Object array, int pos) {
        int length = Array.getLength(array);
        Object dest = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, dest, 0, pos);
        System.arraycopy(array, pos + 1, dest, pos, length - pos - 1);
        return dest;
    }

    public static Object[] getArraySubset(Object[] ids, int start, int end) {
        Object[] subset = new Object[end - start];
        System.arraycopy(ids, start, subset, 0, end - start);
        return subset;
    }
}

