/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.google.inject.internal;

import com.google.common.base.Preconditions;
import io.hops.hadoop.shaded.com.google.inject.Provider;
import io.hops.hadoop.shaded.com.google.inject.internal.Errors;
import io.hops.hadoop.shaded.com.google.inject.internal.ErrorsException;
import io.hops.hadoop.shaded.com.google.inject.internal.InternalContext;
import io.hops.hadoop.shaded.com.google.inject.internal.InternalFactory;
import io.hops.hadoop.shaded.com.google.inject.spi.Dependency;

final class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Provider<? extends T> provider;
    private final Object source;

    public InternalFactoryToProviderAdapter(Provider<? extends T> provider, Object source) {
        this.provider = (Provider)Preconditions.checkNotNull(provider, (Object)"provider");
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) throws ErrorsException {
        try {
            return errors.checkForNull(this.provider.get(), this.source, dependency);
        }
        catch (RuntimeException userException) {
            throw errors.withSource(this.source).errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.provider.toString();
    }
}

