/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.server.impl.application;

import io.hops.hadoop.shaded.com.sun.jersey.api.core.HttpContext;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentContext;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentScope;
import io.hops.hadoop.shaded.com.sun.jersey.spi.CloseableService;
import io.hops.hadoop.shaded.com.sun.jersey.spi.inject.Injectable;
import io.hops.hadoop.shaded.com.sun.jersey.spi.inject.InjectableProvider;
import io.hops.hadoop.shaded.javax.ws.rs.core.Context;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloseableServiceFactory
implements InjectableProvider<Context, Type>,
Injectable<CloseableService>,
CloseableService {
    private static final Logger LOGGER = Logger.getLogger(CloseableServiceFactory.class.getName());
    private final HttpContext context;

    public CloseableServiceFactory(@Context HttpContext context) {
        this.context = context;
    }

    public ComponentScope getScope() {
        return ComponentScope.Singleton;
    }

    public Injectable getInjectable(ComponentContext ic, Context a, Type c) {
        if (c != CloseableService.class) {
            return null;
        }
        return this;
    }

    public CloseableService getValue() {
        return this;
    }

    public void add(Closeable c) {
        HashSet<Closeable> s = (HashSet<Closeable>)this.context.getProperties().get(CloseableServiceFactory.class.getName());
        if (s == null) {
            s = new HashSet<Closeable>();
            this.context.getProperties().put(CloseableServiceFactory.class.getName(), s);
        }
        s.add(c);
    }

    public void close(HttpContext context) {
        Set s = (Set)context.getProperties().get(CloseableServiceFactory.class.getName());
        if (s != null) {
            for (Closeable c : s) {
                try {
                    c.close();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Unable to close", ex);
                }
            }
        }
    }
}

