/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.server.impl.template;

import io.hops.hadoop.shaded.com.sun.jersey.api.view.Viewable;
import io.hops.hadoop.shaded.com.sun.jersey.spi.inject.ConstrainedTo;
import io.hops.hadoop.shaded.com.sun.jersey.spi.inject.ServerSide;
import io.hops.hadoop.shaded.com.sun.jersey.spi.template.ResolvedViewable;
import io.hops.hadoop.shaded.com.sun.jersey.spi.template.TemplateContext;
import io.hops.hadoop.shaded.javax.ws.rs.core.Context;
import io.hops.hadoop.shaded.javax.ws.rs.core.MediaType;
import io.hops.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import io.hops.hadoop.shaded.javax.ws.rs.core.UriInfo;
import io.hops.hadoop.shaded.javax.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@ConstrainedTo(value=ServerSide.class)
public final class ViewableMessageBodyWriter
implements MessageBodyWriter<Viewable> {
    @Context
    UriInfo ui;
    @Context
    TemplateContext tc;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Viewable.class.isAssignableFrom(type);
    }

    public void writeTo(Viewable v, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        ResolvedViewable rv = this.resolve(v);
        if (rv == null) {
            throw new IOException("The template name, " + v.getTemplateName() + ", could not be resolved to a fully qualified template name");
        }
        rv.writeTo(entityStream);
    }

    private ResolvedViewable resolve(Viewable v) {
        if (v instanceof ResolvedViewable) {
            return (ResolvedViewable)v;
        }
        return this.tc.resolveViewable(v, this.ui);
    }

    public long getSize(Viewable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

