/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.netty.channel.sctp;

import io.hops.hadoop.shaded.com.sun.nio.sctp.AbstractNotificationHandler;
import io.hops.hadoop.shaded.com.sun.nio.sctp.AssociationChangeNotification;
import io.hops.hadoop.shaded.com.sun.nio.sctp.HandlerResult;
import io.hops.hadoop.shaded.com.sun.nio.sctp.Notification;
import io.hops.hadoop.shaded.com.sun.nio.sctp.PeerAddressChangeNotification;
import io.hops.hadoop.shaded.com.sun.nio.sctp.SendFailedNotification;
import io.hops.hadoop.shaded.com.sun.nio.sctp.ShutdownNotification;
import io.hops.hadoop.shaded.io.netty.channel.sctp.SctpChannel;

public final class SctpNotificationHandler
extends AbstractNotificationHandler<Object> {
    private final SctpChannel sctpChannel;

    public SctpNotificationHandler(SctpChannel sctpChannel) {
        if (sctpChannel == null) {
            throw new NullPointerException("sctpChannel");
        }
        this.sctpChannel = sctpChannel;
    }

    public HandlerResult handleNotification(AssociationChangeNotification notification, Object o) {
        this.fireEvent((Notification)notification);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(PeerAddressChangeNotification notification, Object o) {
        this.fireEvent((Notification)notification);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(SendFailedNotification notification, Object o) {
        this.fireEvent((Notification)notification);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(ShutdownNotification notification, Object o) {
        this.fireEvent((Notification)notification);
        this.sctpChannel.close();
        return HandlerResult.RETURN;
    }

    private void fireEvent(Notification notification) {
        this.sctpChannel.pipeline().fireUserEventTriggered(notification);
    }
}

