/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataNode;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class DataNodeTest {
    @Test
    public void testGetChildrenShouldReturnEmptySetWhenThereAreNoChidren() {
        DataNode dataNode = new DataNode();
        Set<String> children = dataNode.getChildren();
        Assert.assertNotNull(children);
        Assert.assertEquals((long)0L, (long)children.size());
        String child = "child";
        dataNode.addChild(child);
        dataNode.removeChild(child);
        children = dataNode.getChildren();
        Assert.assertNotNull(children);
        Assert.assertEquals((long)0L, (long)children.size());
        children = dataNode.getChildren();
        try {
            children.add("new child");
            Assert.fail((String)"UnsupportedOperationException is expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetChildrenReturnsImmutableEmptySet() {
        DataNode dataNode = new DataNode();
        Set<String> children = dataNode.getChildren();
        try {
            children.add("new child");
            Assert.fail((String)"UnsupportedOperationException is expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

