/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.NIOServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.RandomAccessFile;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidSnapshotTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidSnapshotTest.class);

    public InvalidSnapshotTest() {
        SyncRequestProcessor.setSnapCount(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSnapshot() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            for (int i = 0; i < 2000; ++i) {
                zk.create("/invalidsnap-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        finally {
            zk.close();
        }
        NIOServerCnxnFactory factory = (NIOServerCnxnFactory)this.serverFactory;
        this.stopServer();
        File snapFile = factory.zkServer.getTxnLogFactory().findMostRecentSnapshot();
        LOG.info("Corrupting " + snapFile);
        RandomAccessFile raf = new RandomAccessFile(snapFile, "rws");
        raf.setLength(3L);
        raf.close();
        this.startServer();
        zk = this.createClient();
        try {
            Assert.assertTrue((String)"the node should exist", (zk.exists("/invalidsnap-1999", false) != null ? 1 : 0) != 0);
        }
        finally {
            zk.close();
        }
    }
}

