/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.NIOServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.NIOServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServerCnxnTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxnTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOperationsAfterCnxnClose() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        String path = "/a";
        try {
            zk.create("/a", "test".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertNotNull((String)"Didn't create znode:/a", (Object)zk.exists("/a", false));
            Assert.assertTrue((String)"Didn't instantiate ServerCnxnFactory with NIOServerCnxnFactory!", (boolean)(this.serverFactory instanceof NIOServerCnxnFactory));
            Iterable<ServerCnxn> connections = this.serverFactory.getConnections();
            for (ServerCnxn serverCnxn : connections) {
                serverCnxn.close();
                try {
                    serverCnxn.toString();
                }
                catch (Exception e) {
                    LOG.error("Exception while getting connection details!", (Throwable)e);
                    Assert.fail((String)"Shouldn't throw exception while getting connection details!");
                }
            }
        }
        finally {
            zk.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testValidSelectionKey() throws Exception {
        ZooKeeper zk = NIOServerCnxnTest.createZKClient(this.hostPort, 3000);
        try {
            Iterable<ServerCnxn> connections = this.serverFactory.getConnections();
            for (ServerCnxn serverCnxn : connections) {
                MockNIOServerCnxn mock = new MockNIOServerCnxn((NIOServerCnxn)serverCnxn);
                ((NIOServerCnxn)serverCnxn).sock.keyFor(((NIOServerCnxnFactory)this.serverFactory).selector).cancel();
                mock.mockSendBuffer(ByteBuffer.allocate(8));
            }
        }
        catch (CancelledKeyException e) {
            LOG.error("Exception while sending bytes!", (Throwable)e);
            Assert.fail((String)e.toString());
        }
        finally {
            zk.close();
        }
    }

    private static class MockNIOServerCnxn
    extends NIOServerCnxn {
        public MockNIOServerCnxn(NIOServerCnxn cnxn) throws IOException {
            super(cnxn.zkServer, cnxn.sock, cnxn.sk, cnxn.factory);
        }

        public void mockSendBuffer(ByteBuffer bb) throws Exception {
            super.internalSendBuffer(bb);
        }
    }
}

