/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Follower;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LearnerHandler;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.net.SocketTimeoutException;
import javax.security.sasl.SaslException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class EphemeralNodeDeletionTest
extends QuorumPeerTestBase {
    private static int SERVER_COUNT = 3;
    private QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];

    @Test(timeout=120000L)
    public void testEphemeralNodeDeletion() throws Exception {
        int i;
        int[] clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        System.out.println(currentQuorumCfgSection);
        for (i = 0; i < SERVER_COUNT; ++i) {
            this.mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection){

                @Override
                public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                    return new MockTestQPMain();
                }
            };
            this.mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        ClientBase.CountdownWatcher watch = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + clientPorts[1], ClientBase.CONNECTION_TIMEOUT, watch);
        watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        String nodePath = "/e1";
        zk.create(nodePath, "1".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        CustomQuorumPeer follower = (CustomQuorumPeer)this.getByServerState(this.mt, QuorumPeer.ServerState.FOLLOWING);
        follower.setInjectError(true);
        zk.close();
        follower.setInjectError(false);
        Assert.assertTrue((String)"Faulted Follower should have joined quorum by now", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + follower.getClientPort(), ClientBase.CONNECTION_TIMEOUT));
        QuorumPeer leader = this.getByServerState(this.mt, QuorumPeer.ServerState.LEADING);
        Assert.assertNotNull((String)"Leader should not be null", (Object)leader);
        Assert.assertTrue((String)"Leader must be running", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + leader.getClientPort(), ClientBase.CONNECTION_TIMEOUT));
        watch = new ClientBase.CountdownWatcher();
        zk = new ZooKeeper("127.0.0.1:" + leader.getClientPort(), ClientBase.CONNECTION_TIMEOUT, watch);
        watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        Stat exists = zk.exists(nodePath, false);
        Assert.assertNull((String)"Node must have been deleted from leader", (Object)exists);
        ClientBase.CountdownWatcher followerWatch = new ClientBase.CountdownWatcher();
        ZooKeeper followerZK = new ZooKeeper("127.0.0.1:" + follower.getClientPort(), ClientBase.CONNECTION_TIMEOUT, followerWatch);
        followerWatch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        Stat nodeAtFollower = followerZK.exists(nodePath, false);
        Assert.assertNull((String)"ephemeral node must not exist", (Object)nodeAtFollower);
        zk.create(nodePath, "2".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        zk.close();
        nodeAtFollower = followerZK.exists(nodePath, false);
        Assert.assertNull((String)"After session close ephemeral node must be deleted", (Object)nodeAtFollower);
        followerZK.close();
    }

    @After
    public void tearDown() {
        for (int i = 0; i < this.mt.length; ++i) {
            try {
                this.mt[i].shutdown();
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("Quorum Peer interrupted while shutting it down", (Throwable)e);
            }
        }
    }

    private QuorumPeer getByServerState(QuorumPeerTestBase.MainThread[] mt, QuorumPeer.ServerState state) {
        for (int i = mt.length - 1; i >= 0; --i) {
            QuorumPeer quorumPeer = mt[i].getQuorumPeer();
            if (null == quorumPeer || state != quorumPeer.getPeerState()) continue;
            return quorumPeer;
        }
        return null;
    }

    static class MockTestQPMain
    extends QuorumPeerTestBase.TestQPMain {
        MockTestQPMain() {
        }

        @Override
        protected QuorumPeer getQuorumPeer() throws SaslException {
            return new CustomQuorumPeer();
        }
    }

    static class CustomQuorumPeer
    extends QuorumPeer {
        private boolean injectError = false;

        @Override
        protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
            return new Follower(this, new FollowerZooKeeperServer(logFactory, this, null, this.getZkDb())){

                @Override
                void readPacket(QuorumPacket pp) throws IOException {
                    super.readPacket(pp);
                    if (CustomQuorumPeer.this.injectError && pp.getType() == 2) {
                        String type = LearnerHandler.packetToString(pp);
                        throw new SocketTimeoutException("Socket timeout while reading the packet for operation " + type);
                    }
                }
            };
        }

        public void setInjectError(boolean injectError) {
            this.injectError = injectError;
        }
    }
}

