/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.jute.OutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.Record;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderBean;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import io.hops.hadoop.shaded.org.mockito.Matchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LeaderBeanTest {
    private Leader leader;
    private LeaderBean leaderBean;
    private FileTxnSnapLog fileTxnSnapLog;
    private LeaderZooKeeperServer zks;
    private QuorumPeer qp;

    @Before
    public void setUp() throws IOException {
        this.qp = new QuorumPeer();
        QuorumVerifier quorumVerifierMock = Mockito.mock(QuorumVerifier.class);
        this.qp.setQuorumVerifier(quorumVerifierMock);
        File tmpDir = ClientBase.createTmpDir();
        this.fileTxnSnapLog = new FileTxnSnapLog(new File(tmpDir, "data"), new File(tmpDir, "data_txnlog"));
        ZKDatabase zkDb = new ZKDatabase(this.fileTxnSnapLog);
        this.zks = new LeaderZooKeeperServer(this.fileTxnSnapLog, this.qp, null, zkDb);
        this.leader = new Leader(this.qp, this.zks);
        this.leaderBean = new LeaderBean(this.leader, this.zks);
    }

    @After
    public void tearDown() throws IOException {
        this.fileTxnSnapLog.close();
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"Leader", (Object)this.leaderBean.getName());
    }

    @Test
    public void testGetCurrentZxid() {
        this.zks.setZxid(1L);
        Assert.assertEquals((Object)"0x1", (Object)this.leaderBean.getCurrentZxid());
    }

    @Test
    public void testGetElectionTimeTaken() {
        this.qp.setElectionTimeTaken(1L);
        Assert.assertEquals((long)1L, (long)this.leaderBean.getElectionTimeTaken());
    }

    @Test
    public void testGetProposalSize() throws IOException, Leader.XidRolloverException {
        Request req = this.createMockRequest();
        this.leader.propose(req);
        byte[] data = SerializeUtils.serializeRequest(req);
        Assert.assertEquals((long)data.length, (long)this.leaderBean.getLastProposalSize());
        Assert.assertEquals((long)data.length, (long)this.leaderBean.getMinProposalSize());
        Assert.assertEquals((long)data.length, (long)this.leaderBean.getMaxProposalSize());
    }

    @Test
    public void testResetProposalStats() throws IOException, Leader.XidRolloverException {
        int initialProposalSize = this.leaderBean.getLastProposalSize();
        Request req = this.createMockRequest();
        this.leader.propose(req);
        Assert.assertNotEquals((long)initialProposalSize, (long)this.leaderBean.getLastProposalSize());
        this.leaderBean.resetProposalStatistics();
        Assert.assertEquals((long)initialProposalSize, (long)this.leaderBean.getLastProposalSize());
        Assert.assertEquals((long)initialProposalSize, (long)this.leaderBean.getMinProposalSize());
        Assert.assertEquals((long)initialProposalSize, (long)this.leaderBean.getMaxProposalSize());
    }

    private Request createMockRequest() throws IOException {
        TxnHeader header = Mockito.mock(TxnHeader.class);
        Mockito.doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("header", "test");
                return null;
            }
        }).when(header).serialize(Matchers.any(OutputArchive.class), Matchers.anyString());
        Record txn = Mockito.mock(Record.class);
        Mockito.doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("record", "test");
                return null;
            }
        }).when(txn).serialize(Matchers.any(OutputArchive.class), Matchers.anyString());
        return new Request(1L, 2, 3, header, txn, 4L);
    }
}

