/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class ZabUtils {
    public static final int SYNC_LIMIT = 2;

    private ZabUtils() {
    }

    public static QuorumPeer createQuorumPeer(File tmpDir) throws IOException {
        QuorumPeer peer = new QuorumPeer();
        peer.syncLimit = 2;
        peer.initLimit = 2;
        peer.tickTime = 2000;
        peer.quorumPeers = new HashMap<Long, QuorumPeer.QuorumServer>();
        peer.quorumPeers.put(0L, new QuorumPeer.QuorumServer(0L, "127.0.0.1", PortAssignment.unique(), 0, null));
        peer.quorumPeers.put(1L, new QuorumPeer.QuorumServer(1L, "127.0.0.1", PortAssignment.unique(), 0, null));
        peer.quorumPeers.put(2L, new QuorumPeer.QuorumServer(2L, "127.0.0.1", PortAssignment.unique(), 0, null));
        peer.setQuorumVerifier(new QuorumMaj(peer.quorumPeers.size()));
        peer.setCnxnFactory(new NullServerCnxnFactory());
        File version2 = new File(tmpDir, "version-2");
        version2.mkdir();
        FileOutputStream fos = new FileOutputStream(new File(version2, "currentEpoch"));
        fos.write("0\n".getBytes());
        fos.close();
        fos = new FileOutputStream(new File(version2, "acceptedEpoch"));
        fos.write("0\n".getBytes());
        fos.close();
        return peer;
    }

    public static Leader createLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException {
        LeaderZooKeeperServer zk = ZabUtils.prepareLeader(tmpDir, peer);
        return new Leader(peer, zk);
    }

    public static MockLeader createMockLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException {
        LeaderZooKeeperServer zk = ZabUtils.prepareLeader(tmpDir, peer);
        return new MockLeader(peer, zk);
    }

    private static LeaderZooKeeperServer prepareLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException {
        FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpDir, tmpDir);
        peer.setTxnFactory(logFactory);
        Field addrField = peer.getClass().getDeclaredField("myQuorumAddr");
        addrField.setAccessible(true);
        addrField.set(peer, new InetSocketAddress(PortAssignment.unique()));
        ZKDatabase zkDb = new ZKDatabase(logFactory);
        return new LeaderZooKeeperServer(logFactory, peer, new ZooKeeperServer.BasicDataTreeBuilder(), zkDb);
    }

    public static final class MockLeader
    extends Leader {
        MockLeader(QuorumPeer qp, LeaderZooKeeperServer zk) throws IOException {
            super(qp, zk);
        }

        public long getCurrentEpochToPropose() {
            return this.epoch;
        }
    }

    private static final class NullServerCnxnFactory
    extends ServerCnxnFactory {
        private NullServerCnxnFactory() {
        }

        @Override
        public void startup(ZooKeeperServer zkServer) throws IOException, InterruptedException {
        }

        @Override
        public void start() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void setMaxClientCnxnsPerHost(int max) {
        }

        @Override
        public void join() throws InterruptedException {
        }

        @Override
        public int getMaxClientCnxnsPerHost() {
            return 0;
        }

        @Override
        public int getLocalPort() {
            return 0;
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return null;
        }

        @Override
        public Iterable<ServerCnxn> getConnections() {
            return null;
        }

        @Override
        public void configure(InetSocketAddress addr, int maxClientCnxns) throws IOException {
        }

        @Override
        public void closeSession(long sessionId) {
        }

        @Override
        public void closeAll() {
        }

        @Override
        public int getNumAliveConnections() {
            return 0;
        }
    }
}

