/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.util;

import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.OutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.Record;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import io.hops.hadoop.shaded.org.mockito.InOrder;
import io.hops.hadoop.shaded.org.mockito.Matchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class SerializeUtilsTest {
    @Test
    public void testSerializeRequestRequestIsNull() {
        byte[] data = SerializeUtils.serializeRequest(null);
        Assert.assertNull((Object)data);
    }

    @Test
    public void testSerializeRequestRequestHeaderIsNull() {
        Request request = new Request(0L, 0, 0, null, null, 0L);
        byte[] data = SerializeUtils.serializeRequest(request);
        Assert.assertNull((Object)data);
    }

    @Test
    public void testSerializeRequestWithoutTxn() throws IOException {
        TxnHeader header = Mockito.mock(TxnHeader.class);
        Mockito.doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("header", "test");
                return null;
            }
        }).when(header).serialize(Matchers.any(OutputArchive.class), Matchers.anyString());
        Request request = new Request(1L, 2, 3, header, null, 4L);
        byte[] data = SerializeUtils.serializeRequest(request);
        Assert.assertNotNull((Object)data);
        Mockito.verify(header).serialize(Matchers.any(OutputArchive.class), Matchers.eq("hdr"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        boa.writeString("header", "test");
        baos.close();
        Assert.assertArrayEquals((byte[])baos.toByteArray(), (byte[])data);
    }

    @Test
    public void testSerializeRequestWithTxn() throws IOException {
        TxnHeader header = Mockito.mock(TxnHeader.class);
        Mockito.doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("header", "test");
                return null;
            }
        }).when(header).serialize(Matchers.any(OutputArchive.class), Matchers.anyString());
        Record txn = Mockito.mock(Record.class);
        Mockito.doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("record", "test");
                return null;
            }
        }).when(txn).serialize(Matchers.any(OutputArchive.class), Matchers.anyString());
        Request request = new Request(1L, 2, 3, header, txn, 4L);
        byte[] data = SerializeUtils.serializeRequest(request);
        Assert.assertNotNull((Object)data);
        InOrder inOrder = Mockito.inOrder(header, txn);
        inOrder.verify(header).serialize(Matchers.any(OutputArchive.class), Matchers.eq("hdr"));
        inOrder.verify(txn).serialize(Matchers.any(OutputArchive.class), Matchers.eq("txn"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        boa.writeString("header", "test");
        boa.writeString("record", "test");
        baos.close();
        Assert.assertArrayEquals((byte[])baos.toByteArray(), (byte[])data);
    }
}

