/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverTest
extends QuorumPeerTestBase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(ObserverTest.class);
    CountDownLatch latch;
    ZooKeeper zk;
    WatchedEvent lastEvent = null;

    @Test
    public void testObserver() throws Exception {
        ClientBase.setupTestEnv();
        this.latch = new CountDownLatch(2);
        int PORT_QP1 = PortAssignment.unique();
        int PORT_QP2 = PortAssignment.unique();
        int PORT_OBS = PortAssignment.unique();
        int PORT_QP_LE1 = PortAssignment.unique();
        int PORT_QP_LE2 = PortAssignment.unique();
        int PORT_OBS_LE = PortAssignment.unique();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        int CLIENT_PORT_OBS = PortAssignment.unique();
        String quorumCfgSection = "electionAlg=3\nserver.1=127.0.0.1:" + PORT_QP1 + ":" + PORT_QP_LE1 + "\nserver.2=127.0.0.1:" + PORT_QP2 + ":" + PORT_QP_LE2 + "\nserver.3=127.0.0.1:" + PORT_OBS + ":" + PORT_OBS_LE + ":observer";
        String obsCfgSection = quorumCfgSection + "\npeerType=observer";
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        QuorumPeerTestBase.MainThread q3 = new QuorumPeerTestBase.MainThread(3, CLIENT_PORT_OBS, obsCfgSection);
        q1.start();
        q2.start();
        q3.start();
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        this.zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, this);
        this.zk.create("/obstest", "test".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(this.zk.getData("/obstest", null, null)), (Object)"test");
        this.zk.sync("/", null, null);
        this.zk.setData("/obstest", "test2".getBytes(), -1);
        this.zk.getChildren("/", false);
        Assert.assertEquals((Object)((Object)this.zk.getState()), (Object)((Object)ZooKeeper.States.CONNECTED));
        LOG.info("Shutting down server 2");
        q2.shutdown();
        Assert.assertTrue((String)"Waiting for server 2 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        LOG.info("Server 2 down");
        this.latch.await();
        Assert.assertNotSame((String)"Client is still connected to non-quorate cluster", (Object)((Object)Watcher.Event.KeeperState.SyncConnected), (Object)((Object)this.lastEvent.getState()));
        LOG.info("Latch returned");
        try {
            Assert.assertFalse((String)"Shouldn't get a response when cluster not quorate!", (boolean)new String(this.zk.getData("/obstest", null, null)).equals("test"));
        }
        catch (KeeperException.ConnectionLossException c) {
            LOG.info("Connection loss exception caught - ensemble not quorate (this is expected)");
        }
        this.latch = new CountDownLatch(1);
        LOG.info("Restarting server 2");
        q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        q2.start();
        LOG.info("Waiting for server 2 to come up");
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        LOG.info("Server 2 started, waiting for latch");
        this.latch.await();
        Assert.assertTrue((String)("Client didn't reconnect to quorate ensemble (state was" + (Object)((Object)this.lastEvent.getState()) + ")"), (Watcher.Event.KeeperState.SyncConnected == this.lastEvent.getState() || Watcher.Event.KeeperState.Expired == this.lastEvent.getState() ? 1 : 0) != 0);
        LOG.info("Shutting down all servers");
        q1.shutdown();
        q2.shutdown();
        q3.shutdown();
        LOG.info("Closing zk client");
        this.zk.close();
        Assert.assertTrue((String)"Waiting for server 1 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Waiting for server 2 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Waiting for server 3 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
    }

    @Override
    public void process(WatchedEvent event) {
        this.lastEvent = event;
        this.latch.countDown();
        LOG.info("Latch got event :: " + event);
    }

    @Test
    public void testObserverOnly() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer\npeerType=observer\n";
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        q1.start();
        q1.join(ClientBase.CONNECTION_TIMEOUT);
        Assert.assertFalse((boolean)q1.isAlive());
    }

    @Test
    public void testObserverWithStandlone() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\npeerType=observer\n";
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        q1.start();
        q1.join(ClientBase.CONNECTION_TIMEOUT);
        Assert.assertFalse((boolean)q1.isAlive());
    }
}

