/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.ClientCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(WatcherTest.class);
    private long timeOfLastWatcherInvocation;
    static final int COUNT = 100;
    final int TIMEOUT = 5000;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ClientCnxn.setDisableAutoResetWatch(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatcherCorrectness() throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = null;
        try {
            String name;
            int i;
            MyWatcher watcher = new MyWatcher();
            zk = this.createClient(watcher, this.hostPort);
            AsyncCallback.StatCallback scb = new AsyncCallback.StatCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, Stat stat) {
                }
            };
            AsyncCallback.VoidCallback vcb = new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                }
            };
            String[] names = new String[10];
            for (i = 0; i < names.length; ++i) {
                names[i] = name = zk.create("/tc-", "initialvalue".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                Stat stat = new Stat();
                zk.getData(name, watcher, stat);
                zk.setData(name, "new".getBytes(), stat.getVersion(), scb, null);
                stat = zk.exists(name, watcher);
                zk.delete(name, stat.getVersion(), vcb, null);
            }
            for (i = 0; i < names.length; ++i) {
                name = names[i];
                WatchedEvent event = watcher.events.poll(10L, TimeUnit.SECONDS);
                Assert.assertEquals((Object)name, (Object)event.getPath());
                Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDataChanged), (Object)((Object)event.getType()));
                Assert.assertEquals((Object)((Object)Watcher.Event.KeeperState.SyncConnected), (Object)((Object)event.getState()));
                event = watcher.events.poll(10L, TimeUnit.SECONDS);
                Assert.assertEquals((Object)name, (Object)event.getPath());
                Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDeleted), (Object)((Object)event.getType()));
                Assert.assertEquals((Object)((Object)Watcher.Event.KeeperState.SyncConnected), (Object)((Object)event.getState()));
            }
        }
        finally {
            if (zk != null) {
                zk.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatcherCount() throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk1 = null;
        ZooKeeper zk2 = null;
        try {
            MyWatcher w1 = new MyWatcher();
            zk1 = this.createClient(w1, this.hostPort);
            MyWatcher w2 = new MyWatcher();
            zk2 = this.createClient(w2, this.hostPort);
            Stat stat = new Stat();
            zk1.create("/watch-count-test", "value".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            zk1.create("/watch-count-test-2", "value".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            zk1.getData("/watch-count-test", w1, stat);
            zk1.getData("/watch-count-test-2", w1, stat);
            zk2.getData("/watch-count-test", w2, stat);
            Assert.assertEquals((long)ClientBase.getServer(this.serverFactory).getZKDatabase().getDataTree().getWatchCount(), (long)3L);
        }
        finally {
            if (zk1 != null) {
                zk1.close();
            }
            if (zk2 != null) {
                zk2.close();
            }
        }
    }

    @Test
    public void testWatchAutoResetWithPending() throws Exception {
        int i;
        MyWatcher[] watches = new MyWatcher[100];
        MyStatCallback[] cbs = new MyStatCallback[100];
        MyWatcher watcher = new MyWatcher();
        int[] count = new int[1];
        TestableZooKeeper zk = this.createClient(watcher, this.hostPort, 6000);
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort, 5000);
        zk2.create("/test", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        for (i = 0; i < 50; ++i) {
            watches[i] = new MyWatcher();
            cbs[i] = new MyStatCallback();
            zk.exists("/test", (Watcher)watches[i], (AsyncCallback.StatCallback)cbs[i], (Object)count);
        }
        zk.exists("/test", false);
        Assert.assertTrue((String)"Failed to pause the connection!", (boolean)zk.pauseCnxn(3000L));
        zk2.close();
        this.stopServer();
        watches[0].waitForDisconnected(60000L);
        for (i = 50; i < 100; ++i) {
            watches[i] = new MyWatcher();
            cbs[i] = new MyStatCallback();
            zk.exists("/test", (Watcher)watches[i], (AsyncCallback.StatCallback)cbs[i], (Object)count);
        }
        this.startServer();
        watches[49].waitForConnected(60000L);
        Assert.assertEquals(null, (Object)zk.exists("/test", false));
        this.waitForAllWatchers();
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((String)("For " + i), (long)1L, (long)watches[i].events.size());
        }
        for (i = 50; i < 100; ++i) {
            if (cbs[i].rc == 0) {
                Assert.assertEquals((String)("For " + i), (long)1L, (long)watches[i].events.size());
                continue;
            }
            Assert.assertEquals((String)("For " + i), (long)0L, (long)watches[i].events.size());
        }
        Assert.assertEquals((long)100L, (long)count[0]);
        zk.close();
    }

    private void waitForAllWatchers() throws Exception {
        this.timeOfLastWatcherInvocation = System.currentTimeMillis();
        while (System.currentTimeMillis() - this.timeOfLastWatcherInvocation < 1000L) {
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testWatcherAutoResetWithGlobal() throws Exception {
        TestableZooKeeper zk = null;
        MyWatcher watcher = new MyWatcher();
        zk = this.createClient(watcher, this.hostPort, 5000);
        this.testWatcherAutoReset((ZooKeeper)zk, watcher, watcher);
        zk.close();
    }

    @Test
    public void testWatcherAutoResetWithLocal() throws Exception {
        TestableZooKeeper zk = null;
        MyWatcher watcher = new MyWatcher();
        zk = this.createClient(watcher, this.hostPort, 5000);
        this.testWatcherAutoReset((ZooKeeper)zk, watcher, new MyWatcher());
        zk.close();
    }

    @Test
    public void testWatcherAutoResetDisabledWithGlobal() throws Exception {
        ClientCnxn.setDisableAutoResetWatch(true);
        this.testWatcherAutoResetWithGlobal();
    }

    @Test
    public void testWatcherAutoResetDisabledWithLocal() throws Exception {
        ClientCnxn.setDisableAutoResetWatch(true);
        this.testWatcherAutoResetWithLocal();
    }

    private void testWatcherAutoReset(ZooKeeper zk, MyWatcher globalWatcher, MyWatcher localWatcher) throws Exception {
        WatchedEvent e;
        boolean isGlobal = localWatcher == globalWatcher;
        zk.create("/watchtest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/watchtest/child", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        if (isGlobal) {
            zk.getChildren("/watchtest", true);
            zk.getData("/watchtest/child", true, new Stat());
            zk.exists("/watchtest/child2", true);
        } else {
            zk.getChildren("/watchtest", localWatcher);
            zk.getData("/watchtest/child", localWatcher, new Stat());
            zk.exists("/watchtest/child2", localWatcher);
        }
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(3000L);
        localWatcher.waitForDisconnected(500L);
        this.startServer();
        globalWatcher.waitForConnected(3000L);
        if (!isGlobal && !ClientCnxn.getDisableAutoResetWatch()) {
            localWatcher.waitForConnected(500L);
        }
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
        zk.setData("/watchtest/child", new byte[1], -1);
        zk.create("/watchtest/child2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        if (!ClientCnxn.getDisableAutoResetWatch()) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)e.getPath(), (Object)((Object)Watcher.Event.EventType.NodeDataChanged), (Object)((Object)e.getType()));
            Assert.assertEquals((Object)"/watchtest/child", (Object)e.getPath());
        }
        if (!ClientCnxn.getDisableAutoResetWatch()) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeCreated), (Object)((Object)e.getType()));
            Assert.assertEquals((Object)"/watchtest/child2", (Object)e.getPath());
        }
        if (!ClientCnxn.getDisableAutoResetWatch()) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
            Assert.assertEquals((Object)"/watchtest", (Object)e.getPath());
        }
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(5000L);
        try {
            try {
                localWatcher.waitForDisconnected(500L);
                if (!isGlobal && !ClientCnxn.getDisableAutoResetWatch()) {
                    Assert.fail((String)"Got an event when I shouldn't have");
                }
            }
            catch (TimeoutException toe) {
                if (ClientCnxn.getDisableAutoResetWatch()) {
                    Assert.fail((String)"Didn't get an event when I should have");
                }
            }
        }
        catch (Exception e1) {
            LOG.error("bad", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        this.startServer();
        globalWatcher.waitForConnected(5000L);
        if (isGlobal) {
            zk.getChildren("/watchtest", true);
            zk.getData("/watchtest/child", true, new Stat());
            zk.exists("/watchtest/child2", true);
        } else {
            zk.getChildren("/watchtest", localWatcher);
            zk.getData("/watchtest/child", localWatcher, new Stat());
            zk.exists("/watchtest/child2", localWatcher);
        }
        zk.delete("/watchtest/child2", -1);
        e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDeleted), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/watchtest/child2", (Object)e.getPath());
        e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/watchtest", (Object)e.getPath());
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(5000L);
        localWatcher.waitForDisconnected(500L);
        this.startServer();
        globalWatcher.waitForConnected(5000L);
        if (!isGlobal && !ClientCnxn.getDisableAutoResetWatch()) {
            localWatcher.waitForConnected(500L);
        }
        zk.delete("/watchtest/child", -1);
        zk.delete("/watchtest", -1);
        if (!ClientCnxn.getDisableAutoResetWatch()) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDeleted), (Object)((Object)e.getType()));
            Assert.assertEquals((Object)"/watchtest/child", (Object)e.getPath());
        }
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

        private MyWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() != Watcher.Event.EventType.None) {
                WatcherTest.this.timeOfLastWatcherInvocation = System.currentTimeMillis();
                try {
                    this.events.put(event);
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt during event.put");
                }
            }
        }
    }

    private final class MyStatCallback
    implements AsyncCallback.StatCallback {
        int rc;

        private MyStatCallback() {
        }

        @Override
        public void processResult(int rc, String path, Object ctx, Stat stat) {
            int[] nArray = (int[])ctx;
            nArray[0] = nArray[0] + 1;
            this.rc = rc;
        }
    }
}

