/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.server;

import io.hops.hadoop.shaded.org.eclipse.jetty.io.AbstractConnection;
import io.hops.hadoop.shaded.org.eclipse.jetty.io.Connection;
import io.hops.hadoop.shaded.org.eclipse.jetty.io.EndPoint;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.AbstractConnectionFactory;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.ConnectionFactory;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.Connector;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.Callback;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.Iterator;

public class ProxyConnectionFactory
extends AbstractConnectionFactory {
    private static final Logger LOG = Log.getLogger(ProxyConnectionFactory.class);
    private final String _next;

    public ProxyConnectionFactory() {
        super("proxy");
        this._next = null;
    }

    public ProxyConnectionFactory(String nextProtocol) {
        super("proxy");
        this._next = nextProtocol;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endp) {
        String next = this._next;
        if (next == null) {
            Iterator<String> i = connector.getProtocols().iterator();
            while (i.hasNext()) {
                String p = i.next();
                if (!this.getProtocol().equalsIgnoreCase(p)) continue;
                next = i.next();
                break;
            }
        }
        return new ProxyConnection(endp, connector, next);
    }

    public static class ProxyEndPoint
    implements EndPoint {
        private final EndPoint _endp;
        private final InetSocketAddress _remote;
        private final InetSocketAddress _local;

        public ProxyEndPoint(EndPoint endp, InetSocketAddress remote, InetSocketAddress local) {
            this._endp = endp;
            this._remote = remote;
            this._local = local;
        }

        @Override
        public boolean isOptimizedForDirectBuffers() {
            return this._endp.isOptimizedForDirectBuffers();
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return this._local;
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return this._remote;
        }

        @Override
        public boolean isOpen() {
            return this._endp.isOpen();
        }

        @Override
        public long getCreatedTimeStamp() {
            return this._endp.getCreatedTimeStamp();
        }

        @Override
        public void shutdownOutput() {
            this._endp.shutdownOutput();
        }

        @Override
        public boolean isOutputShutdown() {
            return this._endp.isOutputShutdown();
        }

        @Override
        public boolean isInputShutdown() {
            return this._endp.isInputShutdown();
        }

        @Override
        public void close() {
            this._endp.close();
        }

        @Override
        public int fill(ByteBuffer buffer) throws IOException {
            return this._endp.fill(buffer);
        }

        @Override
        public boolean flush(ByteBuffer ... buffer) throws IOException {
            return this._endp.flush(buffer);
        }

        @Override
        public Object getTransport() {
            return this._endp.getTransport();
        }

        @Override
        public long getIdleTimeout() {
            return this._endp.getIdleTimeout();
        }

        @Override
        public void setIdleTimeout(long idleTimeout) {
            this._endp.setIdleTimeout(idleTimeout);
        }

        @Override
        public void fillInterested(Callback callback) throws ReadPendingException {
            this._endp.fillInterested(callback);
        }

        @Override
        public boolean tryFillInterested(Callback callback) {
            return this._endp.tryFillInterested(callback);
        }

        @Override
        public boolean isFillInterested() {
            return this._endp.isFillInterested();
        }

        @Override
        public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
            this._endp.write(callback, buffers);
        }

        @Override
        public Connection getConnection() {
            return this._endp.getConnection();
        }

        @Override
        public void setConnection(Connection connection) {
            this._endp.setConnection(connection);
        }

        @Override
        public void onOpen() {
            this._endp.onOpen();
        }

        @Override
        public void onClose() {
            this._endp.onClose();
        }

        @Override
        public void upgrade(Connection newConnection) {
            this._endp.upgrade(newConnection);
        }
    }

    public static class ProxyConnection
    extends AbstractConnection {
        private final int[] __size = new int[]{29, 23, 21, 13, 5, 3, 1};
        private final Connector _connector;
        private final String _next;
        private final StringBuilder _builder = new StringBuilder();
        private final String[] _field = new String[6];
        private int _fields;
        private int _length;

        protected ProxyConnection(EndPoint endp, Connector connector, String next) {
            super(endp, connector.getExecutor());
            this._connector = connector;
            this._next = next;
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.fillInterested();
        }

        @Override
        public void onFillable() {
            try {
                byte b;
                Buffer buffer = null;
                block2: while (true) {
                    int size = Math.max(1, this.__size[this._fields] - this._builder.length());
                    if (buffer == null || buffer.capacity() != size) {
                        buffer = BufferUtil.allocate((int)size);
                    } else {
                        BufferUtil.clear((ByteBuffer)buffer);
                    }
                    int fill = this.getEndPoint().fill((ByteBuffer)buffer);
                    if (fill < 0) {
                        this.getEndPoint().shutdownOutput();
                        return;
                    }
                    if (fill == 0) {
                        this.fillInterested();
                        return;
                    }
                    this._length += fill;
                    if (this._length >= 108) {
                        LOG.warn("PROXY line too long {} for {}", new Object[]{this._length, this.getEndPoint()});
                        this.close();
                        return;
                    }
                    while (true) {
                        if (!buffer.hasRemaining()) continue block2;
                        b = ((ByteBuffer)buffer).get();
                        if (this._fields >= 6) break block2;
                        if (b == 32 || b == 13 && this._fields == 5) {
                            this._field[this._fields++] = this._builder.toString();
                            this._builder.setLength(0);
                            continue;
                        }
                        if (b < 32) {
                            LOG.warn("Bad character {} for {}", new Object[]{b & 0xFF, this.getEndPoint()});
                            this.close();
                            return;
                        }
                        this._builder.append((char)b);
                    }
                    break;
                }
                if (b != 10) {
                    LOG.warn("Bad CRLF for {}", new Object[]{this.getEndPoint()});
                    this.close();
                    return;
                }
                if (!"PROXY".equals(this._field[0])) {
                    LOG.warn("Not PROXY protocol for {}", new Object[]{this.getEndPoint()});
                    this.close();
                    return;
                }
                InetSocketAddress remote = new InetSocketAddress(this._field[2], Integer.parseInt(this._field[4]));
                InetSocketAddress local = new InetSocketAddress(this._field[3], Integer.parseInt(this._field[5]));
                ConnectionFactory connectionFactory = this._connector.getConnectionFactory(this._next);
                if (connectionFactory == null) {
                    LOG.info("Next protocol '{}' for {}", new Object[]{this._next, this.getEndPoint()});
                    this.close();
                    return;
                }
                ProxyEndPoint endPoint = new ProxyEndPoint(this.getEndPoint(), remote, local);
                Connection newConnection = connectionFactory.newConnection(this._connector, endPoint);
                endPoint.upgrade(newConnection);
            }
            catch (Throwable x) {
                LOG.warn("PROXY error for " + this.getEndPoint(), x);
                this.close();
            }
        }
    }
}

