/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.core;

import io.hops.hadoop.shaded.org.ehcache.Cache;
import io.hops.hadoop.shaded.org.ehcache.core.Jsr107Cache;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.Store;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.StoreAccessException;
import java.util.Iterator;

class SpecIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private final Jsr107Cache<K, V> cache;
    private final Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator;
    private Cache.Entry<K, Store.ValueHolder<V>> current;

    public SpecIterator(Jsr107Cache<K, V> cache, Store<K, V> store) {
        this.cache = cache;
        this.iterator = store.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Cache.Entry<K, V> next() {
        try {
            Cache.Entry<K, Store.ValueHolder<Store.ValueHolder<V>>> next = this.iterator.next();
            final K nextKey = next.getKey();
            Store.ValueHolder<V> nextValueHolder = next.getValue();
            if (this.cache.getNoLoader(nextKey) == null) {
                this.current = null;
                return null;
            }
            this.current = next;
            final Object nextValue = nextValueHolder.value();
            return new Cache.Entry<K, V>(){

                @Override
                public K getKey() {
                    return nextKey;
                }

                @Override
                public V getValue() {
                    return nextValue;
                }
            };
        }
        catch (StoreAccessException sae) {
            this.current = null;
            return null;
        }
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.cache.remove(this.current.getKey());
        this.current = null;
    }
}

