/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.events;

import io.hops.hadoop.shaded.org.ehcache.ValueSupplier;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.events.StoreEventFilter;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.events.StoreEventListener;
import io.hops.hadoop.shaded.org.ehcache.event.EventType;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.events.FireableStoreEventHolder;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.events.InvocationScopedEventSink;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;

class FudgingInvocationScopedEventSink<K, V>
extends InvocationScopedEventSink<K, V> {
    FudgingInvocationScopedEventSink(Set<StoreEventFilter<K, V>> filters, boolean ordered, BlockingQueue<FireableStoreEventHolder<K, V>>[] orderedQueues, Set<StoreEventListener<K, V>> listeners) {
        super(filters, ordered, orderedQueues, listeners);
    }

    @Override
    public void evicted(K key, ValueSupplier<V> value) {
        V eventFudgingValue = this.handleEvictionPostWriteOnSameKey(key);
        super.evicted(key, value);
        if (eventFudgingValue != null) {
            this.created(key, eventFudgingValue);
        }
    }

    private V handleEvictionPostWriteOnSameKey(K key) {
        Iterator iterator = this.getEvents().descendingIterator();
        while (iterator.hasNext()) {
            FireableStoreEventHolder eventHolder = iterator.next();
            if (eventHolder.getEvent().getType() == EventType.EVICTED) continue;
            if (eventHolder.getEvent().getKey().equals(key)) {
                switch (eventHolder.getEvent().getType()) {
                    case UPDATED: {
                        eventHolder.markFailed();
                        return eventHolder.getEvent().getNewValue();
                    }
                    case CREATED: {
                        FireableStoreEventHolder next;
                        eventHolder.markFailed();
                        if (iterator.hasNext() && (next = iterator.next()).getEvent().getType() == EventType.EXPIRED && next.getEvent().getKey().equals(key)) {
                            next.markFailed();
                        }
                        return eventHolder.getEvent().getNewValue();
                    }
                }
                continue;
            }
            return null;
        }
        return null;
    }
}

