/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.jsr107;

import io.hops.hadoop.shaded.javax.cache.configuration.CacheEntryListenerConfiguration;
import io.hops.hadoop.shaded.org.ehcache.jsr107.Eh107Expiry;
import io.hops.hadoop.shaded.org.ehcache.jsr107.ListenerResources;
import io.hops.hadoop.shaded.org.ehcache.jsr107.MultiCacheException;
import io.hops.hadoop.shaded.org.ehcache.jsr107.internal.Jsr107CacheLoaderWriter;
import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

class CacheResources<K, V> {
    private final Eh107Expiry<K, V> expiryPolicy;
    private final Jsr107CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> listenerResources = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final String cacheName;

    CacheResources(String cacheName, Jsr107CacheLoaderWriter<? super K, V> cacheLoaderWriter, Eh107Expiry<K, V> expiry, Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> listenerResources) {
        this.cacheName = cacheName;
        this.cacheLoaderWriter = cacheLoaderWriter;
        this.expiryPolicy = expiry;
        this.listenerResources.putAll(listenerResources);
    }

    CacheResources(String cacheName, Jsr107CacheLoaderWriter<? super K, V> cacheLoaderWriter, Eh107Expiry<K, V> expiry) {
        this(cacheName, cacheLoaderWriter, expiry, new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>>());
    }

    Eh107Expiry<K, V> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    Jsr107CacheLoaderWriter<? super K, V> getCacheLoaderWriter() {
        return this.cacheLoaderWriter;
    }

    Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> getListenerResources() {
        return Collections.unmodifiableMap(this.listenerResources);
    }

    synchronized ListenerResources<K, V> registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        this.checkClosed();
        if (this.listenerResources.containsKey(listenerConfig)) {
            throw new IllegalArgumentException("listener config already registered");
        }
        MultiCacheException mce = new MultiCacheException();
        ListenerResources<K, V> rv = ListenerResources.createListenerResources(listenerConfig, mce);
        mce.throwIfNotEmpty();
        this.listenerResources.put(listenerConfig, rv);
        return rv;
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("cache resources closed for cache [" + this.cacheName + "]");
        }
    }

    synchronized ListenerResources<K, V> deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        this.checkClosed();
        ListenerResources<K, V> resources = this.listenerResources.remove(listenerConfig);
        if (resources == null) {
            return null;
        }
        MultiCacheException mce = new MultiCacheException();
        CacheResources.close(resources, mce);
        mce.throwIfNotEmpty();
        return resources;
    }

    synchronized void closeResources(MultiCacheException mce) {
        if (this.closed.compareAndSet(false, true)) {
            CacheResources.close(this.expiryPolicy, mce);
            CacheResources.close(this.cacheLoaderWriter, mce);
            for (ListenerResources<K, V> lr : this.listenerResources.values()) {
                CacheResources.close(lr, mce);
            }
        }
    }

    boolean isClosed() {
        return this.closed.get();
    }

    static void close(Object obj, MultiCacheException mce) {
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable t) {
                mce.addThrowable(t);
            }
        }
    }
}

