/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.compression.zip;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.compression.zip.GZipDecoder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.compression.zip.GZipEncoder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.BaseFilter;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainContext;
import io.hops.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import java.io.IOException;

public class GZipFilter
extends BaseFilter {
    private final GZipDecoder decoder;
    private final GZipEncoder encoder;

    public GZipFilter() {
        this(512, 512);
    }

    public GZipFilter(int inBufferSize, int outBufferSize) {
        this.decoder = new GZipDecoder(inBufferSize);
        this.encoder = new GZipEncoder(outBufferSize);
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        this.decoder.release(connection);
        this.encoder.release(connection);
        return super.handleClose(ctx);
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input;
        Connection connection = ctx.getConnection();
        TransformationResult result = this.decoder.transform(connection, input = (Buffer)ctx.getMessage());
        Buffer remainder = result.getExternalRemainder();
        if (remainder == null) {
            input.tryDispose();
        } else {
            input.shrink();
        }
        try {
            switch (result.getStatus()) {
                case COMPLETE: {
                    ctx.setMessage(result.getMessage());
                    NextAction nextAction = ctx.getInvokeAction(remainder);
                    return nextAction;
                }
                case INCOMPLETE: {
                    NextAction nextAction = ctx.getStopAction(remainder);
                    return nextAction;
                }
                case ERROR: {
                    throw new IllegalStateException("GZip decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getStatus()));
        }
        finally {
            result.recycle();
        }
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Buffer input = (Buffer)ctx.getMessage();
        TransformationResult result = this.encoder.transform(connection, input);
        input.dispose();
        try {
            switch (result.getStatus()) {
                case COMPLETE: 
                case INCOMPLETE: {
                    Buffer readyBuffer = (Buffer)result.getMessage();
                    Buffer finishBuffer = this.encoder.finish(connection);
                    Buffer resultBuffer = Buffers.appendBuffers(connection.getTransport().getMemoryManager(), readyBuffer, finishBuffer);
                    if (resultBuffer != null) {
                        ctx.setMessage(resultBuffer);
                        NextAction nextAction = ctx.getInvokeAction();
                        return nextAction;
                    }
                    NextAction nextAction = ctx.getStopAction();
                    return nextAction;
                }
                case ERROR: {
                    throw new IllegalStateException("GZip decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getStatus()));
        }
        finally {
            result.recycle();
        }
    }
}

