/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.http;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.BufferChunk;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.ByteChunk;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.CookieParserUtils;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.DataChunk;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.MimeHeaders;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Cookies {
    private static final Cookie[] EMPTY_COOKIE_ARRAY;
    private static final Logger logger;
    private static final int INITIAL_SIZE = 4;
    private Cookie[] cookies = new Cookie[4];
    private Cookie[] processedCookies;
    private boolean isProcessed;
    private MimeHeaders headers;
    private int nextUnusedCookieIndex = 0;
    private int storedCookieCount;
    static final char[] SEPARATORS;
    static final boolean[] separators;

    public boolean initialized() {
        return this.headers != null;
    }

    public Cookie[] get() {
        if (!this.isProcessed) {
            this.isProcessed = true;
            this.processCookies();
            this.processedCookies = this.nextUnusedCookieIndex > 0 ? this.copyTo(new Cookie[this.nextUnusedCookieIndex]) : EMPTY_COOKIE_ARRAY;
        }
        return this.processedCookies;
    }

    public void setHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public Cookie getNextUnusedCookie() {
        if (this.nextUnusedCookieIndex < this.storedCookieCount) {
            return this.cookies[this.nextUnusedCookieIndex++];
        }
        Cookie cookie = new Cookie();
        if (this.nextUnusedCookieIndex == this.cookies.length) {
            Cookie[] temp = new Cookie[this.cookies.length + 4];
            System.arraycopy(this.cookies, 0, temp, 0, this.cookies.length);
            this.cookies = temp;
        }
        ++this.storedCookieCount;
        this.cookies[this.nextUnusedCookieIndex++] = cookie;
        return cookie;
    }

    public void recycle() {
        for (int i = 0; i < this.nextUnusedCookieIndex; ++i) {
            this.cookies[i].recycle();
        }
        this.processedCookies = null;
        this.nextUnusedCookieIndex = 0;
        this.headers = null;
        this.isProcessed = false;
    }

    private Cookie[] copyTo(Cookie[] destination) {
        if (this.nextUnusedCookieIndex > 0) {
            System.arraycopy(this.cookies, 0, destination, 0, this.nextUnusedCookieIndex);
        }
        return destination;
    }

    private void processCookies() {
        if (this.headers == null) {
            return;
        }
        int pos = 0;
        while (pos >= 0 && (pos = this.headers.indexOf("Cookie", pos)) >= 0) {
            DataChunk cookieValue = this.headers.getValue(pos);
            if (cookieValue == null || cookieValue.isNull()) {
                ++pos;
                continue;
            }
            DataChunk.Type type = cookieValue.getType();
            switch (type) {
                case Buffer: {
                    if (logger.isLoggable(Level.FINE)) {
                        Cookies.log("Parsing Buffer: " + cookieValue.toString());
                    }
                    BufferChunk bufferChunk = cookieValue.getBufferChunk();
                    CookieParserUtils.parseClientCookies(this, bufferChunk.getBuffer(), bufferChunk.getStart(), bufferChunk.getLength());
                    break;
                }
                case Bytes: {
                    if (logger.isLoggable(Level.FINE)) {
                        Cookies.log("Parsing byte[]: " + cookieValue.toString());
                    }
                    ByteChunk bc = cookieValue.getByteChunk();
                    CookieParserUtils.parseClientCookies(this, bc.getBytes(), bc.getStart(), bc.getLength());
                    break;
                }
                default: {
                    throw new IllegalStateException("Server side cookie parsing for type " + type.name() + ", hasn't been implemented");
                }
            }
            ++pos;
        }
    }

    public String toString() {
        return Arrays.toString(this.cookies);
    }

    private static void log(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Cookies: {0}", s);
        }
    }

    public Cookie findByName(String cookieName) {
        Cookie[] cookiesArray;
        for (Cookie cookie : cookiesArray = this.get()) {
            if (!cookie.lazyNameEquals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    static {
        int i;
        EMPTY_COOKIE_ARRAY = new Cookie[0];
        logger = Grizzly.logger(Cookies.class);
        SEPARATORS = new char[]{'\t', ' ', '\"', '\'', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
        separators = new boolean[128];
        for (i = 0; i < 128; ++i) {
            Cookies.separators[i] = false;
        }
        for (i = 0; i < SEPARATORS.length; ++i) {
            Cookies.separators[Cookies.SEPARATORS[i]] = true;
        }
    }
}

