/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.ssl;

import io.hops.hadoop.shaded.org.glassfish.grizzly.AbstractTransformer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.TransformationException;
import io.hops.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ssl.SSLUtils;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public final class SSLDecoderTransformer
extends AbstractTransformer<Buffer, Buffer> {
    public static final int NEED_HANDSHAKE_ERROR = 1;
    public static final int BUFFER_UNDERFLOW_ERROR = 2;
    public static final int BUFFER_OVERFLOW_ERROR = 3;
    private static final TransformationResult<Buffer, Buffer> HANDSHAKE_NOT_EXECUTED_RESULT = TransformationResult.createErrorResult(1, "Handshake was not executed");
    private static final Logger LOGGER = Grizzly.logger(SSLDecoderTransformer.class);
    private final MemoryManager memoryManager;

    public SSLDecoderTransformer() {
        this(MemoryManager.DEFAULT_MEMORY_MANAGER);
    }

    public SSLDecoderTransformer(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public String getName() {
        return SSLDecoderTransformer.class.getName();
    }

    @Override
    protected TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage state, Buffer originalMessage) throws TransformationException {
        int expectedLength;
        SSLEngine sslEngine = SSLUtils.getSSLEngine(state);
        if (sslEngine == null) {
            return HANDSHAKE_NOT_EXECUTED_RESULT;
        }
        try {
            expectedLength = SSLUtils.getSSLPacketSize(originalMessage);
            if (expectedLength == -1 || originalMessage.remaining() < expectedLength) {
                return TransformationResult.createIncompletedResult(originalMessage);
            }
        }
        catch (SSLException e) {
            throw new TransformationException(e);
        }
        Object targetBuffer = this.memoryManager.allocate(sslEngine.getSession().getApplicationBufferSize());
        TransformationResult<Buffer, Buffer> transformationResult = null;
        try {
            SSLEngineResult sslEngineResult;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "SSLDecoder engine: {0} input: {1} output: {2}", new Object[]{sslEngine, originalMessage, targetBuffer});
            }
            int pos = originalMessage.position();
            if (!originalMessage.isComposite()) {
                sslEngineResult = sslEngine.unwrap(originalMessage.toByteBuffer(), targetBuffer.toByteBuffer());
            } else {
                ByteBuffer originalByteBuffer = originalMessage.toByteBuffer(pos, pos + expectedLength);
                sslEngineResult = sslEngine.unwrap(originalByteBuffer, targetBuffer.toByteBuffer());
            }
            originalMessage.position(pos + sslEngineResult.bytesConsumed());
            targetBuffer.position(sslEngineResult.bytesProduced());
            SSLEngineResult.Status status = sslEngineResult.getStatus();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "SSLDecoderr done engine: {0} result: {1} input: {2} output: {3}", new Object[]{sslEngine, sslEngineResult, originalMessage, targetBuffer});
            }
            if (status == SSLEngineResult.Status.OK) {
                targetBuffer.trim();
                return TransformationResult.createCompletedResult(targetBuffer, originalMessage);
            }
            if (status == SSLEngineResult.Status.CLOSED) {
                targetBuffer.dispose();
                return TransformationResult.createCompletedResult(Buffers.EMPTY_BUFFER, originalMessage);
            }
            targetBuffer.dispose();
            if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                transformationResult = TransformationResult.createIncompletedResult(originalMessage);
            } else if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                transformationResult = TransformationResult.createErrorResult(3, "Buffer overflow during unwrap operation");
            }
        }
        catch (SSLException e) {
            targetBuffer.dispose();
            throw new TransformationException(e);
        }
        return transformationResult;
    }

    @Override
    public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
        return input != null && input.hasRemaining();
    }
}

