/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.cglib.transform.impl;

import io.hops.hadoop.shaded.org.mockito.asm.Type;
import io.hops.hadoop.shaded.org.mockito.cglib.core.Block;
import io.hops.hadoop.shaded.org.mockito.cglib.core.CodeEmitter;
import io.hops.hadoop.shaded.org.mockito.cglib.core.Constants;
import io.hops.hadoop.shaded.org.mockito.cglib.core.EmitUtils;
import io.hops.hadoop.shaded.org.mockito.cglib.core.Signature;
import io.hops.hadoop.shaded.org.mockito.cglib.core.TypeUtils;
import io.hops.hadoop.shaded.org.mockito.cglib.transform.ClassEmitterTransformer;
import java.lang.reflect.Constructor;

public class UndeclaredThrowableTransformer
extends ClassEmitterTransformer {
    private Type wrapper;

    public UndeclaredThrowableTransformer(Class wrapper) {
        this.wrapper = Type.getType(wrapper);
        boolean found = false;
        Constructor<?>[] cstructs = wrapper.getConstructors();
        for (int i = 0; i < cstructs.length; ++i) {
            Class<?>[] types = cstructs[i].getParameterTypes();
            if (types.length != 1 || !types[0].equals(Throwable.class)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException(wrapper + " does not have a single-arg constructor that takes a Throwable");
        }
    }

    public CodeEmitter begin_method(int access, Signature sig, final Type[] exceptions) {
        CodeEmitter e = super.begin_method(access, sig, exceptions);
        if (TypeUtils.isAbstract(access) || sig.equals(Constants.SIG_STATIC)) {
            return e;
        }
        return new CodeEmitter(e){
            private Block handler;
            {
                super(x0);
                this.handler = this.begin_block();
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                this.handler.end();
                EmitUtils.wrap_undeclared_throwable(this, this.handler, exceptions, UndeclaredThrowableTransformer.this.wrapper);
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }
}

