/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;

public class RetryCacheEntryContext
extends BaseEntityContext<RetryCacheEntry.PrimaryKey, RetryCacheEntry> {
    private RetryCacheEntryDataAccess dataAccess;

    public RetryCacheEntryContext(RetryCacheEntryDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public RetryCacheEntry find(FinderType<RetryCacheEntry> finder, Object ... params) throws TransactionContextException, StorageException {
        RetryCacheEntry.Finder hbFinder = (RetryCacheEntry.Finder)finder;
        switch (hbFinder) {
            case ByPK: {
                return this.findByPrimaryKey(hbFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    private RetryCacheEntry findByPrimaryKey(RetryCacheEntry.Finder hbFinder, Object[] params) throws StorageException, StorageCallPreventedException {
        RetryCacheEntry result;
        long epoch;
        byte[] clientId = (byte[])params[0];
        int callId = (Integer)params[1];
        RetryCacheEntry.PrimaryKey pk = new RetryCacheEntry.PrimaryKey(clientId, callId, epoch = ((Long)params[2]).longValue());
        if (this.contains(pk)) {
            result = (RetryCacheEntry)this.get(pk);
            this.hit((FinderType)hbFinder, result, new Object[]{"clientId", clientId, "callId", callId, "epoch", epoch});
        } else {
            this.aboutToAccessStorage((FinderType)hbFinder, params);
            result = this.dataAccess.find(pk);
            this.gotFromDB(pk, result);
            this.miss((FinderType)hbFinder, result, new Object[]{"clientId", clientId, "callId", callId, "epoch", epoch});
        }
        return result;
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getModified());
    }

    RetryCacheEntry.PrimaryKey getKey(RetryCacheEntry retryCacheEntry) {
        return new RetryCacheEntry.PrimaryKey(retryCacheEntry.getClientId(), retryCacheEntry.getCallId(), retryCacheEntry.getEpoch());
    }
}

