/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.util.Shell;

public class ViewFileSystemTestSetup {
    public static String ViewFSTestDir = "/testDir";

    public static FileSystem setupForViewFileSystem(Configuration conf, FileSystemTestHelper fileSystemTestHelper, FileSystem fsTarget) throws Exception {
        Path targetOfTests = fileSystemTestHelper.getTestRootPath(fsTarget);
        fsTarget.delete(targetOfTests, true);
        fsTarget.mkdirs(targetOfTests);
        String testDir = fileSystemTestHelper.getTestRootPath(fsTarget).toUri().getPath();
        ViewFileSystemTestSetup.linkUpFirstComponents(conf, testDir, fsTarget, "test dir");
        ViewFileSystemTestSetup.setUpHomeDir(conf, fsTarget);
        String wdDir = fsTarget.getWorkingDirectory().toUri().getPath();
        ViewFileSystemTestSetup.linkUpFirstComponents(conf, wdDir, fsTarget, "working dir");
        FileSystem fsView = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        fsView.setWorkingDirectory(new Path(wdDir));
        Log.getLog().info("Working dir is: " + fsView.getWorkingDirectory(), new Object[0]);
        return fsView;
    }

    public static void tearDown(FileSystemTestHelper fileSystemTestHelper, FileSystem fsTarget) throws Exception {
        Path targetOfTests = fileSystemTestHelper.getTestRootPath(fsTarget);
        fsTarget.delete(targetOfTests, true);
    }

    public static Configuration createConfig() {
        return ViewFileSystemTestSetup.createConfig(true);
    }

    public static Configuration createConfig(boolean disableCache) {
        Configuration conf = new Configuration();
        conf.set("fs.viewfs.impl", ViewFileSystem.class.getName());
        if (disableCache) {
            conf.set("fs.viewfs.impl.disable.cache", "true");
        }
        return conf;
    }

    static void setUpHomeDir(Configuration conf, FileSystem fsTarget) {
        String homeDir = fsTarget.getHomeDirectory().toUri().getPath();
        int indexOf2ndSlash = homeDir.indexOf(47, 1);
        if (indexOf2ndSlash > 0) {
            ViewFileSystemTestSetup.linkUpFirstComponents(conf, homeDir, fsTarget, "home dir");
        } else {
            URI linkTarget = fsTarget.makeQualified(new Path(homeDir)).toUri();
            ConfigUtil.addLink((Configuration)conf, (String)homeDir, (URI)linkTarget);
            Log.getLog().info("Added link for home dir " + homeDir + "->" + linkTarget, new Object[0]);
        }
        String homeDirRoot = fsTarget.getHomeDirectory().getParent().toUri().getPath();
        ConfigUtil.setHomeDirConf((Configuration)conf, (String)homeDirRoot);
        Log.getLog().info("Home dir base for viewfs" + homeDirRoot, new Object[0]);
    }

    static void linkUpFirstComponents(Configuration conf, String path, FileSystem fsTarget, String info) {
        int indexOfEnd = path.indexOf(47, 1);
        if (Shell.WINDOWS) {
            indexOfEnd = path.indexOf(47, indexOfEnd + 1);
        }
        String firstComponent = path.substring(0, indexOfEnd);
        URI linkTarget = fsTarget.makeQualified(new Path(firstComponent)).toUri();
        ConfigUtil.addLink((Configuration)conf, (String)firstComponent, (URI)linkTarget);
        Log.getLog().info("Added link for " + info + " " + firstComponent + "->" + linkTarget, new Object[0]);
    }
}

