/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class DatanodeJspHelper {
    private static DFSClient getDFSClient(UserGroupInformation user, final String addr, final Configuration conf) throws IOException, InterruptedException {
        return (DFSClient)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DFSClient>(){

            @Override
            public DFSClient run() throws IOException {
                return new DFSClient(NetUtils.createSocketAddr((String)addr), conf);
            }
        });
    }

    public static DFSClient getDFSClient(HttpServletRequest request, DataNode datanode, Configuration conf, UserGroupInformation ugi) throws IOException, InterruptedException {
        String nnAddr = request.getParameter("nnaddr");
        return DatanodeJspHelper.getDFSClient(ugi, nnAddr, conf);
    }
}

