/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import io.hops.hadoop.shaded.com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfEntryInfo;
import org.apache.hadoop.mapreduce.v2.hs.UnparsedJob;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.AMAttemptInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class HsJobBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    HsJobBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p().__(new Object[]{"Sorry, can't do anything without a JobID."}).__();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job j = this.appContext.getJob(jobID);
        if (j == null) {
            html.p().__(new Object[]{"Sorry, ", jid, " not found."}).__();
            return;
        }
        if (j instanceof UnparsedJob) {
            int taskCount = j.getTotalMaps() + j.getTotalReduces();
            UnparsedJob oversizedJob = (UnparsedJob)j;
            html.p().__(new Object[]{"The job has a total of " + taskCount + " tasks. "}).__(new Object[]{"Any job larger than " + oversizedJob.getMaxTasksAllowed() + " will not be loaded."}).__();
            html.p().__(new Object[]{"You can either use the CLI tool: 'mapred job -history' to view large jobs or adjust the property mapreduce.jobhistory.loadedjob.tasks.max."}).__();
            return;
        }
        List amInfos = j.getAMInfos();
        JobInfo job = new JobInfo(j);
        ResponseInfo infoBlock = this.info("Job Overview").__("Job Name:", (Object)job.getName()).__("User Name:", (Object)job.getUserName()).__("Queue:", (Object)job.getQueueName()).__("State:", (Object)job.getState()).__("Uberized:", (Object)job.isUber()).__("Submitted:", (Object)new Date(job.getSubmitTime())).__("Started:", (Object)job.getStartTimeStr()).__("Finished:", (Object)new Date(job.getFinishTime())).__("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)job.getStartTime(), (long)job.getFinishTime(), (boolean)false)));
        String amString = amInfos.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        List diagnostics = j.getDiagnostics();
        if (diagnostics != null && !diagnostics.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (String diag : diagnostics) {
                b.append(HsJobBlock.addTaskLinks(diag));
            }
            infoBlock._r("Diagnostics:", (Object)b.toString());
        }
        if (job.getNumMaps() > 0L) {
            infoBlock.__("Average Map Time", (Object)StringUtils.formatTime((long)job.getAvgMapTime()));
        }
        if (job.getNumReduces() > 0L) {
            infoBlock.__("Average Shuffle Time", (Object)StringUtils.formatTime((long)job.getAvgShuffleTime()));
            infoBlock.__("Average Merge Time", (Object)StringUtils.formatTime((long)job.getAvgMergeTime()));
            infoBlock.__("Average Reduce Time", (Object)StringUtils.formatTime((long)job.getAvgReduceTime()));
        }
        for (ConfEntryInfo entry : job.getAcls()) {
            infoBlock.__("ACL " + entry.getName() + ":", (Object)entry.getValue());
        }
        Hamlet.DIV div = html.__(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.table("#job");
        ((Hamlet.TABLE)table.tr().th(amString).__()).tr().th(".ui-state-default", "Attempt Number").th(".ui-state-default", "Start Time").th(".ui-state-default", "Node").th(".ui-state-default", "Logs").__();
        boolean odd = false;
        for (AMInfo amInfo : amInfos) {
            AMAttemptInfo attempt = new AMAttemptInfo(amInfo, job.getId(), job.getUserName(), "", "");
            odd = !odd;
            ((Hamlet.TR)((Hamlet.TR)table.tr(odd ? ".odd" : ".even").td(String.valueOf(attempt.getAttemptId())).td(new Date(attempt.getStartTime()).toString()).td().a(".nodelink", this.url(new String[]{MRWebAppUtil.getYARNWebappScheme(), attempt.getNodeHttpAddress()}), attempt.getNodeHttpAddress()).__()).td().a(".logslink", this.url(new String[]{attempt.getLogsLink()}), "logs").__()).__();
        }
        table.__();
        div.__();
        ((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TABLE)html.div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#job").tr().th(".ui-state-default", "Task Type").th(".ui-state-default", "Total").th(".ui-state-default", "Complete").__()).tr(".odd").th().a(this.url(new String[]{"tasks", jid, "m"}), "Map").__()).td(String.valueOf(String.valueOf(job.getMapsTotal()))).td(String.valueOf(String.valueOf(job.getMapsCompleted()))).__()).tr(".even").th().a(this.url(new String[]{"tasks", jid, "r"}), "Reduce").__()).td(String.valueOf(String.valueOf(job.getReducesTotal()))).td(String.valueOf(String.valueOf(job.getReducesCompleted()))).__()).__()).table("#job").tr().th(".ui-state-default", "Attempt Type").th(".ui-state-default", "Failed").th(".ui-state-default", "Killed").th(".ui-state-default", "Successful").__()).tr(".odd").th("Maps").td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(job.getFailedMapAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(job.getKilledMapAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(job.getSuccessfulMapAttempts())).__()).__()).tr(".even").th("Reduces").td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(job.getFailedReduceAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(job.getKilledReduceAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(job.getSuccessfulReduceAttempts())).__()).__()).__()).__();
    }

    static String addTaskLinks(String text) {
        return TaskID.taskIdPattern.matcher(text).replaceAll("<a href=\"/jobhistory/task/$0\">$0</a>");
    }
}

