/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.resolvers;

import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.Builder;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryGenericException;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.exceptions.ServiceNotFoundException;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.Lists;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.ARecord;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Lookup;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Resolver;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.ResolverConfig;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.SRVRecord;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.SimpleResolver;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.TextParseException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.NonNull;

public class DnsResolver
implements ServiceDiscoveryClient {
    private Resolver resolver;

    @Override
    public void init(@NonNull Builder builder) throws ServiceDiscoveryGenericException {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        try {
            this.resolver = new SimpleResolver();
            if (builder.getDnsHost() == null || builder.getDnsPort() == null) {
                List<InetSocketAddress> nameservers = ResolverConfig.getCurrentConfig().servers();
                if (nameservers == null || nameservers.isEmpty()) {
                    throw new ServiceDiscoveryGenericException("Unable to find system's nameservers. Check your resolver file or explicitly set DNS host and port in builder");
                }
                ((SimpleResolver)this.resolver).setAddress(nameservers.get(0));
            } else {
                ((SimpleResolver)this.resolver).setAddress(new InetSocketAddress(builder.getDnsHost(), (int)builder.getDnsPort()));
            }
            this.resolver.setTimeout(4);
        }
        catch (UnknownHostException ex) {
            throw new ServiceDiscoveryGenericException(ex);
        }
    }

    @Override
    public Stream<Service> getService(@NonNull ServiceQuery service) throws ServiceDiscoveryException {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (this.resolver == null) {
            throw new ServiceDiscoveryGenericException("DNS resolver has not been initialized");
        }
        try {
            List<Record> SRVRecords = this.getSRVRecords(service);
            return SRVRecords.stream().filter(r -> r.getType() == 33).map(r -> (SRVRecord)r).map(srv -> {
                String aRecord = this.getARecord((SRVRecord)srv);
                if (aRecord == null) {
                    return null;
                }
                return Service.of(service.getName(), aRecord, srv.getPort());
            }).filter(Objects::nonNull);
        }
        catch (TextParseException ex) {
            throw new ServiceDiscoveryGenericException(ex);
        }
    }

    private List<Record> getSRVRecords(ServiceQuery service) throws TextParseException, ServiceNotFoundException {
        try {
            return this.getSRVRecordsInternal(service);
        }
        catch (ServiceNotFoundException ex) {
            ResolverConfig.refresh();
            List<InetSocketAddress> nameservers = ResolverConfig.getCurrentConfig().servers();
            Iterator<InetSocketAddress> nsIterator = nameservers.iterator();
            while (nsIterator.hasNext()) {
                ((SimpleResolver)this.resolver).setAddress(nsIterator.next());
                try {
                    return this.getSRVRecordsInternal(service);
                }
                catch (ServiceNotFoundException ex1) {
                    if (nsIterator.hasNext()) continue;
                    throw ex1;
                }
            }
            throw ex;
        }
    }

    private List<Record> getSRVRecordsInternal(ServiceQuery service) throws TextParseException, ServiceNotFoundException {
        Lookup lookup2 = this.lookup(Name.fromString(service.getName()), 33);
        if (lookup2.getResult() != 0) {
            throw new ServiceNotFoundException("Error: " + lookup2.getErrorString() + " Could not find service " + service);
        }
        return Lists.newArrayList(lookup2.getAnswers());
    }

    private String getARecord(SRVRecord srvRecord) {
        Record[] aRecords;
        Lookup lookup2 = this.lookup(srvRecord.getTarget(), 1);
        for (Record r : aRecords = lookup2.getAnswers()) {
            if (r.getType() != 1) continue;
            ARecord aRecord = (ARecord)r;
            return aRecord.getAddress().getHostAddress();
        }
        return null;
    }

    @VisibleForTesting
    public Lookup lookup(Name name, int type) {
        Lookup lookup2 = new Lookup(name, type);
        lookup2.setResolver(this.resolver);
        lookup2.run();
        return lookup2;
    }

    @Override
    public void close() {
    }
}

